/*!
Trivial Components (https://github.com/trivial-components/trivial-components)

Copyright 2016 Yann Massard (https://github.com/yamass) and other contributors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
import { EditingMode, HighlightDirection, QueryFunction, TrivialComponent, RenderingFunction } from "./TrivialCore";
import { TrivialTreeBoxConfig } from "./TrivialTreeBox";
import { TrivialEvent } from "./TrivialEvent";
export interface TrivialComboBoxConfig<E> extends TrivialTreeBoxConfig<E> {
    /**
     * Calculates the value to set on the original input.
     *
     * @param entry the selected entry
     * @return the string to set as the value of the original input
     */
    inputValueFunction?: (entry: E) => string;
    /**
     * Rendering function used to display a _selected_ entry
     * (i.e. an entry inside the editor area of the component, not the dropdown).
     *
     * @param entry
     * @return HTML string
     * @default `wrapWithDefaultTagWrapper(entryRenderingFunction(entry))`
     */
    selectedEntryRenderingFunction?: RenderingFunction<E>;
    /**
     * Initially selected entry.
     *
     * @default `null`
     */
    selectedEntry?: E;
    /**
     * Performance setting. Defines the maximum number of entries until which text highlighting is performed.
     * Set to `0` to disable text highlighting.
     *
     * @default `100`
     */
    textHighlightingEntryLimit?: number;
    /**
     * Used to retrieve the entries ("suggestions") to be displayed in the dropdown box.
     *
     * @see QueryFunction
     * @default creates a client-side query function using the provided [[entries]]
     */
    queryFunction?: QueryFunction<E>;
    /**
     * Whether or not to provide auto-completion.
     *
     * @default `true`
     */
    autoComplete?: boolean;
    /**
     * The number of milliseconds to wait until auto-completion is performed.
     *
     * @default `0`
     */
    autoCompleteDelay?: number;
    /**
     * Generates an autocompletion string for the current input of the user and currently highlighted entry in the dropdown.
     *
     * @param editorText the current text input from the user
     * @param entry the currently highlighted entry in the dropdown
     * @return The _full_ string (not only the completion part) to apply for auto-completion.
     * @default best effort implementation using entry properties
     */
    autoCompleteFunction?: (editorText: string, entry: E) => string;
    /**
     * Similar to [[autoCompleteFunction]]. Used to set the editor's text when focusing the component.
     *
     * @default `entry["displayValue"]`
     */
    entryToEditorTextFunction?: (entry: E) => string;
    /**
     * Whether or not to allow free text to be entered by the user.
     *
     * @default `false`
     */
    allowFreeText?: boolean;
    /**
     * Creates an entry (object) from a string entered by the user.
     *
     * @param freeText the text entered by the user
     * @default `{ displayValue: freeText, _isFreeTextEntry: true }`
     */
    freeTextEntryFactory?: (freeText: string) => E | any;
    /**
     * The clear button is a the small 'x' at the right of the entry display that can be clicked to clear the selection.
     */
    showClearButton?: boolean;
    /**
     * The trigger is the button on the right side of the component that can be clicket to open the dropdown.
     *
     * @default `true`
     */
    showTrigger?: boolean;
    editingMode?: EditingMode;
    /**
     * It `true`, opening the dropdown will be delayed until the result callback of the [[queryFunction]] is called.
     *
     * @default `false`
     */
    showDropDownOnResultsOnly?: boolean;
    /**
     * HTML string defining the spinner to be displayed while entries are being retrieved.
     */
    spinnerTemplate?: string;
}
export declare class TrivialComboBox<E> implements TrivialComponent {
    private $comboBox;
    private $dropDown;
    private popper;
    private $dropDownTargetElement;
    private config;
    private $editor;
    private treeBox;
    private _isDropDownOpen;
    private isEditorVisible;
    private selectedEntry;
    private lastCommittedValue;
    private blurCausedByClickInsideComponent;
    private autoCompleteTimeoutId;
    private doNoAutoCompleteBecauseBackspaceWasPressed;
    private editingMode;
    private usingDefaultQueryFunction;
    private $originalInput;
    private $selectedEntryWrapper;
    private $clearButton;
    private $trigger;
    private $spinners;
    readonly onSelectedEntryChanged: TrivialEvent<E>;
    readonly onFocus: TrivialEvent<void>;
    readonly onBlur: TrivialEvent<void>;
    constructor(originalInput: HTMLElement, options?: TrivialComboBoxConfig<E>);
    private query;
    private showSpinner;
    private hideSpinner;
    private fireChangeEvents;
    setSelectedEntry(entry: E, commit: boolean, fireEvent?: boolean, originalEvent?: unknown): void;
    private isEntrySelected;
    private showEditor;
    private getEditorArea;
    private editorContainsFreeText;
    private hideEditor;
    private repositionDropDown;
    openDropDown(): void;
    closeDropDown(): void;
    private getNonSelectedEditorValue;
    private autoCompleteIfPossible;
    updateEntries(newEntries: E[], highlightDirection?: HighlightDirection): void;
    private isDropDownNeeded;
    setEditingMode(newEditingMode: EditingMode): void;
    getSelectedEntry(): E;
    getDropDownComponent(): TrivialComponent;
    focus(): void;
    getEditor(): Element;
    getDropDown(): JQuery<HTMLElement>;
    setShowClearButton(showClearButton: boolean): void;
    setShowTrigger(showTrigger: boolean): void;
    isDropDownOpen(): boolean;
    destroy(): void;
    getMainDomElement(): Element;
}
