export declare enum DebounceMode {
    IMMEDIATE = 0,
    LATER = 1,
    BOTH = 2
}
export declare function debouncedMethod(delay: number, mode?: DebounceMode): (target: any, propertyKey: string, descriptor: PropertyDescriptor) => void;
/**
 *  Returns a function, that, as long as it continues to be invoked, will not be triggered.
 *  The function will be called after it stops being called for N milliseconds.
 *
 *  @see throttle
 */
export declare function debounce(func: (...args: any[]) => any, delay: number, mode?: DebounceMode): ((...args: any[]) => void);
