import { TrivialDateTimeField } from "../../trivial-components/TrivialDateTimeField";
import { UiFieldEditingMode } from "../../../generated/UiFieldEditingMode";
import { UiField } from "../UiField";
import { TeamAppsUiContext } from "../../TeamAppsUiContext";
import { AbstractUiDateTimeFieldCommandHandler, AbstractUiDateTimeFieldConfig, AbstractUiDateTimeFieldEventSource } from "../../../generated/AbstractUiDateTimeFieldConfig";
import { UiDateTimeFormatDescriptorConfig } from "../../../generated/UiDateTimeFormatDescriptorConfig";
import { DateTime } from "luxon";
import { DateSuggestionEngine } from "./DateSuggestionEngine";
export declare abstract class AbstractUiDateTimeField<C extends AbstractUiDateTimeFieldConfig, V> extends UiField<C, V> implements AbstractUiDateTimeFieldEventSource, AbstractUiDateTimeFieldCommandHandler {
    protected trivialDateTimeField: TrivialDateTimeField;
    protected dateSuggestionEngine: DateSuggestionEngine;
    protected dateRenderer: (time: DateTime) => string;
    protected timeRenderer: (time: DateTime) => string;
    protected initialize(config: AbstractUiDateTimeFieldConfig, context: TeamAppsUiContext): void;
    protected abstract getTimeZone(): string;
    protected createDateRenderer(): (time: DateTime) => string;
    protected createTimeRenderer(): (time: DateTime) => string;
    protected dateTimeToDateString(dateTime: DateTime): string;
    protected dateTimeToTimeString(dateTime: DateTime): string;
    private updateDateSuggestionEngine;
    getMainInnerDomElement(): HTMLElement;
    getFocusableElement(): HTMLElement;
    focus(): void;
    hasFocus(): boolean;
    protected onEditingModeChanged(editingMode: UiFieldEditingMode): void;
    destroy(): void;
    getDefaultValue(): V;
    setLocaleAndFormats(locale: string, dateFormat: UiDateTimeFormatDescriptorConfig, timeFormat: UiDateTimeFormatDescriptorConfig): void;
    setFavorPastDates(favorPastDates: boolean): void;
    setShowDropDownButton(showDropDownButton: boolean): void;
}
