import { LocalDateTime } from "../../util/LocalDateTime";
export interface DateSuggestion {
    date: LocalDateTime;
    ymdOrder: string;
}
export declare type YearMonthDayOrder = "YMD" | "YDM" | "MDY" | "MYD" | "DMY" | "DYM";
export interface Options {
    locale?: string;
    preferredYearMonthDayOrder?: YearMonthDayOrder;
    /**
     * By default, the engine favors future dates. This flag makes it favor past dates.
     */
    favorPastDates?: boolean;
}
export declare class DateSuggestionEngine {
    private preferredYmdOrder;
    private favorPastDates;
    constructor(options: Options);
    generateSuggestions(searchString: string, now: LocalDateTime): LocalDateTime[];
    private removeDuplicateDates;
    generateSuggestionsForDigitsOnlyInput(input: string, today: LocalDateTime): DateSuggestion[];
    todayOrFavoriteDirection(date: LocalDateTime, today: LocalDateTime): boolean;
    private createSuggestionsForFragments;
    private findNextValidDate;
}
export declare function getYearMonthDayOrderFromDateFormat(dateFormat: string): YearMonthDayOrder;
export declare function getYearMonthDayOrderFromLocale(locale: string): YearMonthDayOrder;
