/*!
 Trivial Components (https://github.com/trivial-components/trivial-components)

 Copyright 2016 Yann Massard (https://github.com/yamass) and other contributors

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
import { EditingMode, TrivialComponent } from "./TrivialCore";
import { TrivialEvent } from "./TrivialEvent";
import { DateTime } from "luxon";
import DateTimeFormatOptions = Intl.DateTimeFormatOptions;
export interface TrivialDateTimeFieldConfig {
    locale?: string;
    timeZone?: string;
    dateFormat?: DateTimeFormatOptions;
    timeFormat?: DateTimeFormatOptions;
    autoComplete?: boolean;
    autoCompleteDelay?: number;
    showTrigger?: boolean;
    editingMode?: EditingMode;
    favorPastDates?: boolean;
}
export interface LocalDate {
    year: number;
    month: number;
    day: number;
}
export interface LocalTime {
    hour: number;
    minute: number;
    second?: number;
}
export declare class TrivialDateTimeField implements TrivialComponent {
    private config;
    private dateIconRenderer;
    private timeIconRenderer;
    private dateRenderer;
    private timeRenderer;
    readonly onChange: TrivialEvent<DateTime>;
    private dateListBox;
    private timeListBox;
    private calendarBox;
    private _isDropDownOpen;
    private value;
    private blurCausedByClickInsideComponent;
    private focusGoesToOtherEditor;
    private autoCompleteTimeoutId;
    private doNoAutoCompleteBecauseBackspaceWasPressed;
    private calendarBoxInitialized;
    private editingMode;
    private dropDownMode;
    private $dateTimeField;
    private $dropDown;
    private popper;
    private $dateIconWrapper;
    private $dateEditor;
    private $timeIconWrapper;
    private $timeEditor;
    private $dropDownTargetElement;
    private $dateListBoxWrapper;
    private $timeListBoxWrapper;
    private $calendarBoxWrapper;
    private $activeEditor;
    private dateSuggestionEngine;
    private timeSuggestionEngine;
    constructor(options?: TrivialDateTimeFieldConfig);
    private updateRenderers;
    private isDropDownNeeded;
    private setDropDownMode;
    private getActiveBox;
    private getActiveEditor;
    private selectHighlightedListBoxEntry;
    private query;
    private queryDate;
    private queryTime;
    getValue(): DateTime;
    private fireChangeEvents;
    private setDate;
    private setTime;
    setValue(value: DateTime, fireEvent?: boolean): void;
    private updateDisplay;
    private repositionDropDown;
    openDropDown(): void;
    closeDropDown(): void;
    private getNonSelectedEditorValue;
    private autoCompleteIfPossible;
    setEditingMode(newEditingMode: EditingMode): void;
    setLocale(locale: string): void;
    setDateFormat(dateFormat: DateTimeFormatOptions): void;
    setTimeFormat(timeFormat: DateTimeFormatOptions): void;
    setLocaleAndFormats(locale: string, dateFormat: DateTimeFormatOptions, timeFormat: DateTimeFormatOptions): void;
    focus(): void;
    isDropDownOpen(): boolean;
    destroy(): void;
    getMainDomElement(): Element;
}
