import { UiAudioTrackConstraintsConfig } from "../../generated/UiAudioTrackConstraintsConfig";
import { UiVideoTrackConstraintsConfig } from "../../generated/UiVideoTrackConstraintsConfig";
import { UiScreenSharingConstraintsConfig } from "../../generated/UiScreenSharingConstraintsConfig";
import { UiMediaDeviceInfoConfig } from "../../generated/UiMediaDeviceInfoConfig";
export declare function addVoiceActivityDetectionToMediaStream(mediaStream: MediaStream, onVoiceStart: () => void, onVoiceStop: () => void): void;
export declare function addVoiceActivityDetection(audioTrack: MediaStreamTrack, onVoiceStart: () => void, onVoiceStop: () => void): void;
export declare function retrieveUserMedia(audioConstraints: UiAudioTrackConstraintsConfig, videoConstraints: UiVideoTrackConstraintsConfig, screenSharingConstraints: UiScreenSharingConstraintsConfig, streamEndedHandler: (stream: MediaStream, isDisplay: boolean) => void): Promise<{
    sourceStreams: MediaStream[];
    targetStream: MediaStream;
}>;
export declare function createVideoConstraints(videoConstraints: UiVideoTrackConstraintsConfig): MediaTrackConstraints;
export declare function createDisplayMediaStreamConstraints(screenSharingConstraints: UiScreenSharingConstraintsConfig): {
    video: {
        frameRate: {
            max: number;
            ideal: number;
        };
        width: {
            max: number;
            ideal: number;
        };
        height: {
            max: number;
            ideal: number;
        };
    };
    audio: boolean;
};
export declare function getDisplayStream(screenSharingConstraints: UiScreenSharingConstraintsConfig): Promise<MediaStream>;
export declare function canPublishScreen(): boolean;
export declare function enumerateDevices(): Promise<UiMediaDeviceInfoConfig[]>;
