/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icons;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.icons.Icon;
import org.teamapps.icons.IconProvider;
import org.teamapps.icons.IconResource;
import org.teamapps.icons.spi.IconDecoder;
import org.teamapps.icons.spi.IconEncoder;
import org.teamapps.icons.spi.IconLoader;

public class SessionIconProvider {
    private final IconProvider iconProvider;
    private final Map<Class<? extends Icon>, Object> defaultStyleByIconClass = new HashMap<Class<? extends Icon>, Object>();

    public SessionIconProvider(IconProvider iconProvider) {
        this.iconProvider = iconProvider;
    }

    public <I extends Icon<I, S>, S> String encodeIcon(I icon) {
        return this.encodeIcon(icon, false);
    }

    public <I extends Icon<I, S>, S> String encodeIcon(I icon, boolean fallbackToDefaultStyle) {
        IconEncoder<?> encoder = this.iconProvider.getIconEncoder(icon.getClass());
        if (icon.getStyle() == null && fallbackToDefaultStyle) {
            Object style = this.defaultStyleByIconClass.computeIfAbsent(icon.getClass(), iClass -> this.iconProvider.getDefaultStyle(iClass));
            icon = icon.withStyle((Object)style);
        }
        return this.iconProvider.getLibraryName(icon) + "." + encoder.encodeIcon(icon, i -> this.encodeIcon(i, fallbackToDefaultStyle));
    }

    public Icon<?, ?> decodeIcon(String qualifiedEncodedIconString) {
        return this.iconProvider.decodeIcon(qualifiedEncodedIconString);
    }

    public IconResource loadIcon(String qualifiedEncodedIconString, int size) {
        return this.iconProvider.loadIcon(qualifiedEncodedIconString, size);
    }

    public IconResource loadIcon(Icon<?, ?> icon, int size) {
        return this.iconProvider.loadIcon(icon, size);
    }

    public <I extends Icon<I, S>, S> void registerIconLibrary(Class<I> iconClass) {
        this.iconProvider.registerIconLibrary(iconClass);
    }

    public <I extends Icon<I, S>, S> void registerIconLibrary(Class<I> iconClass, String libraryName, IconEncoder<I> iconEncoder, IconDecoder<I> iconDecoder, IconLoader<I> iconLoader, S defaultStyle) {
        this.iconProvider.registerIconLibrary(iconClass, libraryName, iconEncoder, iconDecoder, iconLoader, defaultStyle);
    }

    public <I extends Icon<I, S>, S> void setDefaultStyleForIconClass(Class<I> iconClass, S defaultStyle) {
        this.iconProvider.registerIconLibrary(iconClass);
        this.defaultStyleByIconClass.put(iconClass, defaultStyle);
    }
}

