/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icons.systemprovider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class CachingIconProvider {
    private File cacheDirectory;

    public CachingIconProvider() {
        try {
            this.cacheDirectory = File.createTempFile("icon-cache", "temp").getParentFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CachingIconProvider(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    public byte[] getCachedIcon(int size, String iconId) {
        File icon = this.createFilePath(size, iconId);
        return this.getCachedFile(icon);
    }

    public byte[] getCachedIcon(String libraryId, String styleId, int size, String iconName) {
        File icon = this.createFilePath(libraryId, styleId, size, iconName);
        return this.getCachedFile(icon);
    }

    private byte[] getCachedFile(File file) {
        if (file.exists()) {
            try {
                return IOUtils.toByteArray((InputStream)new FileInputStream(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean puIconInCache(int size, String iconId, byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        File icon = this.createFilePath(size, iconId);
        return this.writeCacheFile(icon, bytes);
    }

    public boolean putIconInCache(String libraryId, String styleId, int size, String iconName, byte[] bytes) {
        File icon = this.createFilePath(libraryId, styleId, size, iconName);
        return this.writeCacheFile(icon, bytes);
    }

    private boolean writeCacheFile(File file, byte[] bytes) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bytes);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private File createFilePath(String libraryId, String styleId, int size, String iconName) {
        return new File(this.cacheDirectory, libraryId + "." + styleId + "." + size + "." + iconName + ".png");
    }

    private File createFilePath(int size, String iconId) {
        return new File(this.cacheDirectory, size + "." + iconId + ".png");
    }
}

