/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icons.systemprovider;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.teamapps.icons.api.CustomIconStyle;
import org.teamapps.icons.api.IconStyle;
import org.teamapps.icons.api.StyledCompositeIcon;
import org.teamapps.icons.api.StyledIcon;
import org.teamapps.icons.provider.IconProvider;
import org.teamapps.icons.systemprovider.CachingIconProvider;
import org.teamapps.icons.systemprovider.CompositeIconProvider;
import org.teamapps.icons.systemprovider.CompositeSvgProvider;
import org.teamapps.icons.systemprovider.IconResource;
import org.teamapps.icons.systemprovider.ResizingIconProvider;
import org.teamapps.icons.systemprovider.StylingIconProvider;

public class SystemIconProvider {
    private IconProvider standardIconProvider;
    private Map<String, IconProvider> iconProviderByStyleId = new HashMap<String, IconProvider>();
    private Map<String, IconProvider> iconProviderByLibraryId = new HashMap<String, IconProvider>();
    private Map<String, CustomIconStyle> customIconStyleByStyleId = new HashMap<String, CustomIconStyle>();
    private CachingIconProvider cachingIconProvider;
    private ResizingIconProvider resizingIconProvider = new ResizingIconProvider();
    private StylingIconProvider stylingIconProvider = new StylingIconProvider();
    private CompositeIconProvider compositeIconProvider = new CompositeIconProvider();
    private CompositeSvgProvider compositeSvgProvider = new CompositeSvgProvider();

    public SystemIconProvider() {
        this.cachingIconProvider = new CachingIconProvider();
    }

    public SystemIconProvider(File cachingDirectory) {
        this.cachingIconProvider = new CachingIconProvider(cachingDirectory);
    }

    public IconResource getIcon(int size, String qualifiedIconId) {
        boolean isSVG = qualifiedIconId.endsWith(".svg");
        byte[] bytes = this.getIconBytes(size, isSVG, qualifiedIconId);
        if (bytes != null) {
            String mimeType = isSVG ? "image/svg+xml" : "image/png";
            return new IconResource(bytes, mimeType);
        }
        return null;
    }

    public byte[] getIconBytes(int size, boolean isSVG, String qualifiedIconId) {
        try {
            boolean composed = StyledCompositeIcon.isComposedIcon(qualifiedIconId);
            if (composed) {
                return this.getComposedIcon(size, qualifiedIconId, isSVG);
            }
            return this.getSingleIcon(size, qualifiedIconId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] getSingleIcon(int size, StyledIcon styledIcon) {
        if (styledIcon == null) {
            return null;
        }
        return this.getSingleIcon(size, styledIcon.getQualifiedIconId());
    }

    private byte[] getSingleIcon(int size, String qualifiedIconId) {
        IconProvider iconProvider;
        byte[] cachedIcon = this.cachingIconProvider.getCachedIcon(size, qualifiedIconId);
        if (cachedIcon != null) {
            return cachedIcon;
        }
        StyledIcon styledIcon = StyledIcon.parseIcon(qualifiedIconId);
        if (styledIcon == null) {
            return null;
        }
        String iconLibraryId = styledIcon.getIconLibraryId();
        String styleId = styledIcon.getStyleId();
        String iconName = styledIcon.getIconName();
        String providerStyleId = styleId;
        CustomIconStyle customIconStyle = this.customIconStyleByStyleId.get(styleId);
        if (customIconStyle != null) {
            providerStyleId = customIconStyle.getBaseStyleId();
        }
        if ((iconProvider = this.getIconProvider(iconLibraryId, providerStyleId)) == null) {
            return null;
        }
        byte[] iconBytes = null;
        boolean convertedIcon = false;
        if (iconProvider.getAvailableIconSizes() != null && !iconProvider.getAvailableIconSizes().isEmpty() && !iconProvider.getAvailableIconSizes().contains(size)) {
            convertedIcon = true;
            int resizeSize = this.calculateResizeSize(size, iconProvider.getAvailableIconSizes());
            byte[] icon = iconProvider.getIcon(providerStyleId, resizeSize, iconName);
            iconBytes = this.resizingIconProvider.resizeIcon(icon, size);
        } else {
            iconBytes = iconProvider.getIcon(providerStyleId, size, iconName);
        }
        if (customIconStyle != null && iconBytes != null && !qualifiedIconId.contains(".flag_")) {
            convertedIcon = true;
            iconBytes = this.stylingIconProvider.styleIcon(customIconStyle, iconBytes);
        }
        if (convertedIcon) {
            this.cachingIconProvider.puIconInCache(size, qualifiedIconId, iconBytes);
        }
        return iconBytes;
    }

    private IconProvider getIconProvider(String iconLibraryId, String styleId) {
        IconProvider iconProvider = null;
        if (this.standardIconProvider.getIconLibraryId().equals(iconLibraryId)) {
            iconProvider = this.standardIconProvider;
        }
        if (iconProvider == null) {
            iconProvider = this.iconProviderByLibraryId.get(iconLibraryId);
        }
        if (iconProvider == null) {
            iconProvider = this.iconProviderByStyleId.get(styleId);
        }
        return iconProvider;
    }

    private int calculateResizeSize(int requiredSize, Set<Integer> availableSizes) {
        int bestFit = this.calculateResizeSize(requiredSize, availableSizes, 2.0, 4.0, 3.0, 1.5);
        if (bestFit > 0) {
            return bestFit;
        }
        for (Integer size : availableSizes) {
            if (bestFit == 0) {
                bestFit = size;
                continue;
            }
            if (bestFit >= requiredSize * 2 || size <= bestFit) continue;
            bestFit = size;
        }
        return bestFit;
    }

    private int calculateResizeSize(int requiredSize, Set<Integer> availableSizes, double ... factors) {
        for (double factor : factors) {
            if (!availableSizes.contains((int)((double)requiredSize * factor))) continue;
            return (int)((double)requiredSize * factor);
        }
        return 0;
    }

    private byte[] getComposedSvgIcon(int size, String qualifiedIconId) {
        byte[] cachedIcon = this.cachingIconProvider.getCachedIcon(size, qualifiedIconId);
        if (cachedIcon != null) {
            return cachedIcon;
        }
        StyledCompositeIcon composedIcon = StyledCompositeIcon.parse(qualifiedIconId);
        if (composedIcon == null) {
            return null;
        }
        byte[] iconBytes = null;
        this.cachingIconProvider.puIconInCache(size, qualifiedIconId, iconBytes);
        return iconBytes;
    }

    private byte[] getComposedIcon(int size, String qualifiedIconId, boolean isSVG) {
        byte[] cachedIcon = this.cachingIconProvider.getCachedIcon(size, qualifiedIconId);
        if (cachedIcon != null) {
            return cachedIcon;
        }
        StyledCompositeIcon composedIcon = StyledCompositeIcon.parse(qualifiedIconId);
        if (composedIcon == null) {
            return null;
        }
        byte[] baseIcon = this.getSingleIcon(size, composedIcon.getBaseIcon());
        byte[] bottomRight = this.getSingleIcon(size / 2, composedIcon.getBottomRightIcon());
        byte[] bottomLeft = this.getSingleIcon(size / 2, composedIcon.getBottomLeftIcon());
        byte[] topLeft = this.getSingleIcon(size / 2, composedIcon.getTopLeftIcon());
        byte[] topRight = this.getSingleIcon(size / 2, composedIcon.getTopRightIcon());
        byte[] iconBytes = null;
        iconBytes = isSVG ? this.compositeSvgProvider.createComposedIcon(size, baseIcon, bottomRight, bottomLeft, topLeft, topRight) : this.compositeIconProvider.createComposedIcon(size, baseIcon, bottomRight, bottomLeft, topLeft, topRight);
        this.cachingIconProvider.puIconInCache(size, qualifiedIconId, iconBytes);
        return iconBytes;
    }

    public IconProvider getStandardIconProvider() {
        return this.standardIconProvider;
    }

    public void registerStandardIconProvider(IconProvider iconProvider) {
        this.standardIconProvider = iconProvider;
        this.registerCustomIconProvider(iconProvider);
    }

    public void registerCustomIconProvider(IconProvider<?> iconProvider) {
        for (IconStyle iconStyle : iconProvider.getAvailableIconStyles()) {
            if (iconStyle instanceof CustomIconStyle) {
                this.customIconStyleByStyleId.put(iconStyle.getStyleId(), (CustomIconStyle)iconStyle);
                continue;
            }
            this.iconProviderByStyleId.put(iconStyle.getStyleId(), iconProvider);
        }
        this.iconProviderByLibraryId.put(iconProvider.getIconLibraryId(), iconProvider);
    }

    public void registerCustomIconStyle(CustomIconStyle customIconStyle) {
        this.customIconStyleByStyleId.put(customIconStyle.getStyleId(), customIconStyle);
    }
}

