/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icons.api;

import org.teamapps.icons.api.Icon;
import org.teamapps.icons.api.IconTheme;
import org.teamapps.icons.api.StyledIcon;

public class StyledCompositeIcon
implements Icon {
    private StyledIcon baseIcon;
    private StyledIcon bottomRightIcon;
    private StyledIcon bottomLeftIcon;
    private StyledIcon topLeftIcon;
    private StyledIcon topRightIcon;

    public static boolean isComposedIcon(String icon) {
        return icon != null && icon.startsWith("x-multi-icon.");
    }

    public static StyledCompositeIcon parse(String icon) {
        if (icon == null) {
            return null;
        }
        if (!icon.startsWith("x-multi-icon.")) {
            StyledIcon baseIcon = StyledIcon.parseIcon(icon);
            return new StyledCompositeIcon(baseIcon);
        }
        int pos = (icon = icon.substring("x-multi-icon.".length())).indexOf(".x-sub-");
        if (pos < 0) {
            StyledIcon baseIcon = StyledIcon.parseIcon(icon);
            return new StyledCompositeIcon(baseIcon);
        }
        String baseIconId = icon.substring(0, pos);
        StyledIcon baseIcon = StyledIcon.parseIcon(baseIconId);
        StyledCompositeIcon composedIcon = new StyledCompositeIcon(baseIcon);
        while (pos >= 0) {
            int index = Integer.parseInt(icon.substring(pos + ".x-sub-".length(), pos + ".x-sub-".length() + 1));
            int subIconStartPos = pos + ".x-sub-".length() + 2;
            pos = icon.indexOf(".x-sub-", subIconStartPos);
            String subIcon = null;
            subIcon = pos < 0 ? icon.substring(subIconStartPos) : icon.substring(subIconStartPos, pos);
            composedIcon.setSubIconByIndex(subIcon, index);
        }
        return composedIcon;
    }

    private void setSubIconByIndex(String subIconId, int index) {
        StyledIcon subIcon = StyledIcon.parseIcon(subIconId);
        switch (index) {
            case 1: {
                this.bottomRightIcon = subIcon;
                break;
            }
            case 2: {
                this.bottomLeftIcon = subIcon;
                break;
            }
            case 3: {
                this.topLeftIcon = subIcon;
                break;
            }
            case 4: {
                this.topRightIcon = subIcon;
            }
        }
    }

    public StyledCompositeIcon(StyledIcon baseIcon) {
        this.baseIcon = baseIcon;
    }

    public StyledCompositeIcon(StyledIcon baseIcon, StyledIcon bottomRightIcon, StyledIcon bottomLeftIcon, StyledIcon topLeftIcon, StyledIcon topRightIcon) {
        this.baseIcon = baseIcon;
        this.bottomRightIcon = bottomRightIcon;
        this.bottomLeftIcon = bottomLeftIcon;
        this.topLeftIcon = topLeftIcon;
        this.topRightIcon = topRightIcon;
    }

    public StyledIcon getBaseIcon() {
        return this.baseIcon;
    }

    public StyledIcon getBottomLeftIcon() {
        return this.bottomLeftIcon;
    }

    public StyledIcon getBottomRightIcon() {
        return this.bottomRightIcon;
    }

    public StyledIcon getTopLeftIcon() {
        return this.topLeftIcon;
    }

    public StyledIcon getTopRightIcon() {
        return this.topRightIcon;
    }

    @Override
    public String getQualifiedIconId(IconTheme theme, boolean baseStyle) {
        StringBuilder sb = new StringBuilder();
        sb.append("x-multi-icon.");
        sb.append(this.baseIcon.getQualifiedIconId());
        if (this.bottomRightIcon != null) {
            sb.append(".x-sub-1.");
            sb.append(this.bottomRightIcon.getQualifiedIconId());
        }
        if (this.bottomLeftIcon != null) {
            sb.append(".x-sub-2.");
            sb.append(this.bottomLeftIcon.getQualifiedIconId());
        }
        if (this.topLeftIcon != null) {
            sb.append(".x-sub-3.");
            sb.append(this.topLeftIcon.getQualifiedIconId());
        }
        if (this.topRightIcon != null) {
            sb.append(".x-sub-4.");
            sb.append(this.topRightIcon.getQualifiedIconId());
        }
        return sb.toString();
    }

    public String toString() {
        return "StyledComposedIcon{baseIcon=" + this.baseIcon + ", bottomLeftIcon=" + this.bottomLeftIcon + ", bottomRightIcon=" + this.bottomRightIcon + ", topLeftIcon=" + this.topLeftIcon + ", topRightIcon=" + this.topRightIcon + "}";
    }
}

