/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icons;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.teamapps.icons.Icon;
import org.teamapps.icons.IconCache;
import org.teamapps.icons.IconDecoderContext;
import org.teamapps.icons.IconLibraryRegistry;
import org.teamapps.icons.IconLoaderContext;
import org.teamapps.icons.IconResource;
import org.teamapps.icons.IconType;
import org.teamapps.icons.PngIconResizer;
import org.teamapps.icons.spi.IconDecoder;
import org.teamapps.icons.spi.IconEncoder;
import org.teamapps.icons.spi.IconLoader;

public class IconProvider
implements IconLoaderContext,
IconDecoderContext {
    private final IconLibraryRegistry iconLibraryRegistry;
    private final IconCache iconCache;

    public IconProvider(IconLibraryRegistry iconLibraryRegistry) {
        this.iconLibraryRegistry = iconLibraryRegistry;
        try {
            this.iconCache = new IconCache(Files.createTempDirectory("teamapps-icon-cache", new FileAttribute[0]).toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IconProvider(IconLibraryRegistry iconLibraryRegistry, IconCache iconCache) {
        this.iconLibraryRegistry = iconLibraryRegistry;
        this.iconCache = iconCache;
    }

    @Override
    public Icon<?, ?> decodeIcon(String qualifiedEncodedIcon) {
        String libraryName = this.getLibraryName(qualifiedEncodedIcon);
        String encodedIconString = qualifiedEncodedIcon.substring(libraryName.length() + 1);
        IconDecoder iconDecoder = this.iconLibraryRegistry.getIconDecoder(libraryName);
        return iconDecoder.decodeIcon(encodedIconString, this);
    }

    public IconResource loadIcon(String qualifiedEncodedIcon, int size) {
        IconResource cachedIcon;
        if (this.iconCache != null && (cachedIcon = this.iconCache.getCachedIcon(qualifiedEncodedIcon, size)) != null) {
            return cachedIcon;
        }
        String libraryName = this.getLibraryName(qualifiedEncodedIcon);
        String encodedIconString = qualifiedEncodedIcon.substring(libraryName.length() + 1);
        IconDecoder iconDecoder = this.iconLibraryRegistry.getIconDecoder(libraryName);
        Object icon = iconDecoder.decodeIcon(encodedIconString, this);
        IconResource iconResource = this.loadIconWithoutCaching((Icon<?, ?>)icon, size);
        if (iconResource == null) {
            return null;
        }
        if (this.iconCache != null) {
            this.iconCache.putIcon(qualifiedEncodedIcon, size, iconResource);
        }
        return iconResource;
    }

    @Override
    public IconResource loadIcon(Icon<?, ?> icon, int size) {
        return this.loadIconWithoutCaching(icon, size);
    }

    private IconResource loadIconWithoutCaching(Icon<?, ?> icon, int size) {
        String libraryName = this.getLibraryName(icon);
        IconLoader iconLoader = this.iconLibraryRegistry.getIconLoader(libraryName);
        IconResource iconResource = iconLoader.loadIcon(icon, size, this);
        if (iconResource == null) {
            return null;
        }
        if (iconResource.getIconType().isRasterImage() && iconResource.getSize() > 0 && size > 0 && iconResource.getSize() != size) {
            byte[] resizedIconBytes = new PngIconResizer().resizeIcon(iconResource.getBytes(), size);
            iconResource = new IconResource(resizedIconBytes, IconType.PNG, size);
        }
        return iconResource;
    }

    public <I extends Icon<I, S>, S> IconEncoder<I> getIconEncoder(Class<I> iconClass) {
        return this.iconLibraryRegistry.getIconEncoder(iconClass);
    }

    public <I extends Icon<I, S>, S> String getLibraryName(Icon icon) {
        return this.iconLibraryRegistry.getLibraryName(icon);
    }

    public <I extends Icon<I, S>, S> void registerIconLibrary(Class<I> iconClass) {
        this.iconLibraryRegistry.registerIconLibrary(iconClass);
    }

    public <I extends Icon<I, S>, S> void registerIconLibrary(Class<I> iconClass, String libraryName, IconEncoder<I> iconEncoder, IconDecoder<I> iconDecoder, IconLoader<I> iconLoader, S defaultStyle) {
        this.iconLibraryRegistry.registerIconLibrary(iconClass, libraryName, iconEncoder, iconDecoder, iconLoader, defaultStyle);
    }

    public <I extends Icon<I, S>, S> S getDefaultStyle(Class<I> iconClass) {
        return this.iconLibraryRegistry.getDefaultStyle(iconClass);
    }

    private String getLibraryName(String qualifiedEncodedIcon) {
        int firstDotIndex = qualifiedEncodedIcon.indexOf(46);
        return qualifiedEncodedIcon.substring(0, firstDotIndex);
    }
}

