/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.icons.composite;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.icons.Icon;
import org.teamapps.icons.IconDecoderContext;
import org.teamapps.icons.composite.CompositeIcon;
import org.teamapps.icons.spi.IconDecoder;
import org.teamapps.icons.util.IconEncodeDecodeUtil;

public class CompositeIconDecoder
implements IconDecoder<CompositeIcon> {
    @Override
    public CompositeIcon decodeIcon(String encodedIconString, IconDecoderContext context) {
        Map<Integer, String> subIconDescriptionsByPositionIndex = this.extractSubIconDescriptions(encodedIconString);
        Icon<?, ?> baseIcon = context.decodeIcon(subIconDescriptionsByPositionIndex.get(0));
        Icon<?, ?> bottomRight = subIconDescriptionsByPositionIndex.containsKey(1) ? context.decodeIcon(subIconDescriptionsByPositionIndex.get(1)) : null;
        Icon<?, ?> bottomLeft = subIconDescriptionsByPositionIndex.containsKey(2) ? context.decodeIcon(subIconDescriptionsByPositionIndex.get(2)) : null;
        Icon<?, ?> topLeft = subIconDescriptionsByPositionIndex.containsKey(3) ? context.decodeIcon(subIconDescriptionsByPositionIndex.get(3)) : null;
        Icon<?, ?> topRight = subIconDescriptionsByPositionIndex.containsKey(4) ? context.decodeIcon(subIconDescriptionsByPositionIndex.get(4)) : null;
        return CompositeIcon.of(baseIcon, bottomRight, bottomLeft, topLeft, topRight);
    }

    private Map<Integer, String> extractSubIconDescriptions(String encodedIconString) {
        HashMap<Integer, String> subIconDescriptions = new HashMap<Integer, String>();
        int pos = 0;
        while (pos < encodedIconString.length()) {
            int iconPositionIndex = encodedIconString.charAt(pos) - 48;
            int endPos = IconEncodeDecodeUtil.findClosingParenthesisPosition(encodedIconString, pos += 2);
            String encodedSubIconString = encodedIconString.substring(pos, endPos);
            pos = endPos + 1;
            subIconDescriptions.put(iconPositionIndex, encodedSubIconString);
        }
        return subIconDescriptions;
    }
}

