/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto.generate;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.TeamAppsDtoParser;
import org.teamapps.dto.generate.ParserFactory;

public class TeamAppsGeneratorUtil {
    public static List<File> getFilesInDirectory(File sourceDir) {
        File[] files = sourceDir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Directory does not exist: " + sourceDir);
        }
        return Arrays.asList(files);
    }

    public static List<TeamAppsDtoParser.ClassCollectionContext> parseClassCollections(File sourceDir) {
        return TeamAppsGeneratorUtil.getFilesInDirectory(sourceDir).stream().map(dtoFile -> {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream((File)dtoFile), "UTF-8");
                return ParserFactory.createParser(reader).classCollection();
            }
            catch (Exception e1) {
                throw new IllegalArgumentException("Exception while parsing " + dtoFile.getPath() + ": " + e1.getMessage(), e1);
            }
        }).collect(Collectors.toList());
    }
}

