/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto.generate.adapter;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.RuleContext;
import org.apache.commons.lang3.StringUtils;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.misc.STNoSuchPropertyException;
import org.teamapps.dto.TeamAppsDtoParser;
import org.teamapps.dto.generate.TeamAppsDtoModel;
import org.teamapps.dto.generate.adapter.PojoModelAdaptor;

public class TypeContextModelAdaptor
extends PojoModelAdaptor {
    static final Map<String, String> PRIMITIVE_TYPE_TO_WRAPPER_TYPE = new HashMap<String, String>();
    private static final Map<String, String> PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE = new HashMap<String, String>();
    private static final Map<String, String> PRIMITIVE_TYPE_TO_DEFAULT_VALUE = new HashMap<String, String>();
    private static final Map<String, String> TYPESCRIPT_PRIMITIVE_TYPE_TO_DEFAULT_VALUE = new HashMap<String, String>();
    private static final Set<String> IMPLICITELY_REFERENCEABLE_CLASSES = Sets.newHashSet((Object[])new String[]{"UiEvent", "UiCommand"});
    private final TeamAppsDtoModel astUtil;

    public TypeContextModelAdaptor(TeamAppsDtoModel astUtil) {
        this.astUtil = astUtil;
    }

    @Override
    public Object getProperty(Interpreter interpreter, ST self, Object o, Object property, String propertyName) throws STNoSuchPropertyException {
        TeamAppsDtoParser.TypeContext typeContext = (TeamAppsDtoParser.TypeContext)((Object)o);
        if ("javaTypeString".equals(propertyName)) {
            return this.getJavaTypeString(typeContext);
        }
        if ("isUiComponentId".equals(propertyName)) {
            return this.isUiComponentId(typeContext);
        }
        if ("isString".equals(propertyName)) {
            return "String".equals(typeContext.getText());
        }
        if ("isEnum".equals(propertyName)) {
            return typeContext.inlineEnum() != null || this.astUtil.findReferencedEnum(typeContext) != null;
        }
        if ("isList".equals(propertyName)) {
            return this.isList(typeContext);
        }
        if ("isDictionary".equals(propertyName)) {
            return this.isDictionary(typeContext);
        }
        if ("isReferenceList".equals(propertyName)) {
            return this.isList(typeContext) && this.isReferenceToJsonAware(this.getFirstTypeArgument(typeContext));
        }
        if ("firstTypeArgument".equals(propertyName)) {
            return this.getFirstTypeArgument(typeContext);
        }
        if ("isReferenceToJsonAware".equals(propertyName)) {
            return this.isReferenceToJsonAware(typeContext);
        }
        if ("isTypeScriptConfig".equals(propertyName)) {
            return this.isTypeScriptConfigSuffixed(typeContext);
        }
        if ("isPrimitiveType".equals(propertyName)) {
            return PRIMITIVE_TYPE_TO_WRAPPER_TYPE.keySet().contains(typeContext.getText());
        }
        if ("isPrimitiveOrWrapperType".equals(propertyName)) {
            return PRIMITIVE_TYPE_TO_WRAPPER_TYPE.keySet().contains(typeContext.getText()) || PRIMITIVE_TYPE_TO_WRAPPER_TYPE.values().contains(typeContext.getText());
        }
        if ("isPrimitiveNumberOrNumberWrapperType".equals(propertyName)) {
            return Arrays.asList("byte", "Byte", "short", "Short", "int", "Integer", "long", "Long", "float", "Float", "double", "Double").contains(typeContext.getText());
        }
        if ("isBoolean".equals(propertyName)) {
            return "boolean".equals(typeContext.getText());
        }
        if ("primitiveType".equals(propertyName)) {
            if (PRIMITIVE_TYPE_TO_WRAPPER_TYPE.keySet().contains(typeContext.getText())) {
                return typeContext.getText();
            }
            if (PRIMITIVE_TYPE_TO_WRAPPER_TYPE.values().contains(typeContext.getText())) {
                return PRIMITIVE_TYPE_TO_WRAPPER_TYPE.get(typeContext.getText());
            }
            throw new IllegalArgumentException(typeContext.getText() + " is not a primitive type!");
        }
        if ("isReference".equals(propertyName)) {
            return this.isReference(typeContext);
        }
        if ("objectType".equals(propertyName)) {
            if (PRIMITIVE_TYPE_TO_WRAPPER_TYPE.keySet().contains(typeContext.getText())) {
                return PRIMITIVE_TYPE_TO_WRAPPER_TYPE.get(typeContext.getText());
            }
            return typeContext.getText();
        }
        if ("defaultValue".equals(propertyName)) {
            return PRIMITIVE_TYPE_TO_DEFAULT_VALUE.getOrDefault(typeContext.getText(), "null");
        }
        if ("typeScriptType".equals(propertyName)) {
            return this.getTypeScriptType(typeContext);
        }
        if ("isObjectReference".equals(propertyName)) {
            if (this.isObject(typeContext)) {
                return true;
            }
            TeamAppsDtoParser.TypeContext firstTypeArgument = this.getFirstTypeArgument(typeContext);
            return firstTypeArgument != null && this.isObject(firstTypeArgument);
        }
        return super.getProperty(interpreter, self, o, property, propertyName);
    }

    private String getJavaTypeString(TeamAppsDtoParser.TypeContext typeContext) {
        if (typeContext.inlineEnum() != null) {
            String propName = ((TeamAppsDtoParser.PropertyDeclarationContext)typeContext.parent).Identifier().getText();
            return StringUtils.capitalize((String)propName);
        }
        if (typeContext.subCommandReference() != null) {
            String className = typeContext.subCommandReference().typeReference().Identifier().getText();
            return className + "." + className + "SubCommand";
        }
        if (typeContext.subEventReference() != null) {
            String className = typeContext.subEventReference().typeReference().Identifier().getText();
            return className + "." + className + "SubEvent";
        }
        if (this.isList(typeContext)) {
            TeamAppsDtoParser.TypeContext firstTypeArgument = this.getFirstTypeArgument(typeContext);
            if (this.isObject(firstTypeArgument)) {
                return "List";
            }
            return "List<" + this.getJavaTypeString(firstTypeArgument) + ">";
        }
        if (this.isDictionary(typeContext)) {
            return "Map<String, " + this.getJavaTypeString(typeContext.typeReference().typeArguments().typeArgument(0).type()) + ">";
        }
        if (this.isReference(typeContext)) {
            return this.astUtil.findSelfNearestAncestorClassWithReferenceableAttribute(this.astUtil.findReferencedClass(typeContext)).Identifier().getText() + "Reference";
        }
        if (this.isUiComponentId(typeContext)) {
            return "String";
        }
        if (this.isRawJsonString(typeContext)) {
            return "@com.fasterxml.jackson.annotation.JsonRawValue String";
        }
        return typeContext.getText();
    }

    private boolean isReference(TeamAppsDtoParser.TypeContext typeContext) {
        return typeContext.typeReference() != null && typeContext.typeReference().referenceTypeModifier() != null;
    }

    private boolean isUiComponentId(TeamAppsDtoParser.TypeContext typeContext) {
        return "UiComponentId".equals(typeContext.getText());
    }

    private String getTypeScriptType(TeamAppsDtoParser.TypeContext typeContext) {
        if (this.isObject(typeContext)) {
            return "any";
        }
        if (typeContext.inlineEnum() != null) {
            TeamAppsDtoParser.PropertyDeclarationContext propertyDecl = (TeamAppsDtoParser.PropertyDeclarationContext)typeContext.getParent();
            String propertyName = propertyDecl.Identifier().getText();
            TeamAppsDtoParser.ClassDeclarationContext classDeclaration = TeamAppsDtoModel.findAncestorOfType((RuleContext)propertyDecl, TeamAppsDtoParser.ClassDeclarationContext.class);
            return classDeclaration.Identifier().getText() + "_" + StringUtils.capitalize((String)propertyName);
        }
        if (typeContext.subCommandReference() != null) {
            return "any";
        }
        if (typeContext.subEventReference() != null) {
            return "UiSubEvent";
        }
        if ("String".equals(typeContext.getText())) {
            return "string";
        }
        if (this.isList(typeContext)) {
            return this.getTypeScriptType(this.getFirstTypeArgument(typeContext)) + "[]";
        }
        if (this.isDictionary(typeContext)) {
            return "{[name: string]: " + this.getTypeScriptType(this.getFirstTypeArgument(typeContext)) + "}";
        }
        if (this.isUiComponentId(typeContext)) {
            return "string";
        }
        if (this.isReference(typeContext)) {
            return "unknown";
        }
        if (IMPLICITELY_REFERENCEABLE_CLASSES.contains(typeContext.getText())) {
            return typeContext.getText();
        }
        if (this.isTypeScriptConfigSuffixed(typeContext)) {
            return typeContext.typeReference().Identifier().getText() + "Config";
        }
        if (PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.containsKey(typeContext.getText())) {
            return PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.get(typeContext.getText());
        }
        if (this.isRawJsonString(typeContext)) {
            return "any";
        }
        return typeContext.getText();
    }

    private boolean isObject(TeamAppsDtoParser.TypeContext typeContext) {
        return typeContext.typeReference() != null && "Object".equals(typeContext.typeReference().Identifier().getText());
    }

    private boolean isReferenceToJsonAware(TeamAppsDtoParser.TypeContext typeContext) {
        return this.astUtil.findReferencedClass(typeContext) != null || this.astUtil.findReferencedInterface(typeContext) != null || typeContext.subCommandReference() != null || typeContext.subEventReference() != null || IMPLICITELY_REFERENCEABLE_CLASSES.contains(typeContext.getText());
    }

    private boolean isTypeScriptConfigSuffixed(TeamAppsDtoParser.TypeContext typeContext) {
        return this.astUtil.findReferencedClass(typeContext) != null || this.astUtil.findReferencedInterface(typeContext) != null;
    }

    private boolean isList(TeamAppsDtoParser.TypeContext typeContext) {
        return typeContext.typeReference() != null && "List".equals(typeContext.typeReference().Identifier().getText());
    }

    private boolean isDictionary(TeamAppsDtoParser.TypeContext typeContext) {
        return typeContext.typeReference() != null && "Dictionary".equals(typeContext.typeReference().Identifier().getText());
    }

    private boolean isRawJsonString(TeamAppsDtoParser.TypeContext typeContext) {
        return typeContext.typeReference() != null && "RawJson".equals(typeContext.typeReference().Identifier().getText());
    }

    private TeamAppsDtoParser.TypeContext getFirstTypeArgument(TeamAppsDtoParser.TypeContext typeContext) {
        if (typeContext.typeReference() != null && typeContext.typeReference().typeArguments() != null && !typeContext.typeReference().typeArguments().typeArgument().isEmpty()) {
            return typeContext.typeReference().typeArguments().typeArgument(0).type();
        }
        return null;
    }

    static {
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put("boolean", "Boolean");
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put("char", "Character");
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put("byte", "Byte");
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put("short", "Short");
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put("int", "Integer");
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put("long", "Long");
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put("float", "Float");
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put("double", "Double");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("boolean", "boolean");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("char", "string");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("byte", "number");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("short", "number");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("int", "number");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("long", "number");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("float", "number");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("double", "number");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("Boolean", "boolean");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("Character", "string");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("Byte", "number");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("Short", "number");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("Integer", "number");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("Long", "number");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("Float", "number");
        PRIMITIVE_TYPE_TO_TYPESCRIPT_TYPE.put("Double", "number");
        PRIMITIVE_TYPE_TO_DEFAULT_VALUE.put("boolean", "false");
        PRIMITIVE_TYPE_TO_DEFAULT_VALUE.put("char", "0");
        PRIMITIVE_TYPE_TO_DEFAULT_VALUE.put("byte", "0");
        PRIMITIVE_TYPE_TO_DEFAULT_VALUE.put("short", "0");
        PRIMITIVE_TYPE_TO_DEFAULT_VALUE.put("int", "0");
        PRIMITIVE_TYPE_TO_DEFAULT_VALUE.put("long", "0");
        PRIMITIVE_TYPE_TO_DEFAULT_VALUE.put("float", "0");
        PRIMITIVE_TYPE_TO_DEFAULT_VALUE.put("double", "0");
    }
}

