/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import junit.framework.TestCase;
import org.teiid.core.CorePlugin;
import org.teiid.core.util.Assertion;

public class TestAssertion
extends TestCase {
    private static final String TEST_MESSAGE = "This is a test assertion message";

    public TestAssertion(String name) {
        super(name);
    }

    public void testAssertTrueboolean() {
        Assertion.assertTrue((boolean)true);
        try {
            Assertion.assertTrue((boolean)false);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            String msg = CorePlugin.Util.getString("Assertion.Assertion_failed");
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testAssertTruebooleanString() {
        Assertion.assertTrue((boolean)true, (String)TEST_MESSAGE);
        try {
            Assertion.assertTrue((boolean)false, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testFailed() {
        try {
            Assertion.failed(null);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)"null", (String)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.failed((String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNullObject() {
        Assertion.isNull(null);
        try {
            Assertion.isNull((Object)"");
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            String msg = CorePlugin.Util.getString("Assertion.isNull");
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNullObjectString() {
        Assertion.isNull(null, (String)TEST_MESSAGE);
        try {
            Assertion.isNull((Object)"", (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNotNullObject() {
        Assertion.isNotNull((Object)"");
        try {
            Assertion.isNotNull(null);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            String msg = CorePlugin.Util.getString("Assertion.isNotNull");
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNotNullObjectString() {
        Assertion.isNotNull((Object)"", (String)TEST_MESSAGE);
        try {
            Assertion.isNotNull(null, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsInstanceOf() {
        Assertion.isInstanceOf((Object)new Integer(1), Integer.class, (String)"name");
        Assertion.isInstanceOf((Object)"asdfasdf", String.class, (String)"name2");
        try {
            Assertion.isInstanceOf((Object)new Integer(1), Long.class, (String)"name3");
            TestAssertion.fail();
        }
        catch (ClassCastException e) {
            Object[] params = new Object[]{"name3", Long.class, Integer.class.getName()};
            String msg = CorePlugin.Util.getString("Assertion.invalidClassMessage", params);
            TestAssertion.assertEquals((String)msg, (String)e.getMessage());
        }
    }

    public void testIsNotEmptyCollection() {
    }

    public void testIsNotEmptyCollectionString() {
    }

    public void testIsNotEmptyMap() {
    }

    public void testIsNotEmptyMapString() {
    }

    public void testContainsCollectionObject() {
    }

    public void testContainsCollectionObjectString() {
    }

    public void testContainsKeyMapObject() {
    }

    public void testContainsKeyMapObjectString() {
    }
}

