/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.basic.NumberToNumberTransform;

public class NumberToIntegerTransform
extends NumberToNumberTransform {
    private boolean isNarrowing;

    public NumberToIntegerTransform(Class<?> sourceType, boolean isNarrowing) {
        super(Integer.MIN_VALUE, Integer.MAX_VALUE, sourceType);
        this.isNarrowing = isNarrowing;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.isNarrowing) {
            this.checkValueRange(value);
        }
        return ((Number)value).intValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.INTEGER;
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing;
    }
}

