/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.core.serializer.SerializerResultImpl;
import org.apache.olingo.server.core.serializer.json.ODataJsonSerializer;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.utils.ContextURLBuilder;
import org.teiid.olingo.ComplexReturnType;

public class TeiidODataJsonSerializer
extends ODataJsonSerializer {
    public TeiidODataJsonSerializer(ContentType contentType) {
        super(contentType);
    }

    public SerializerResult complexCollection(ServiceMetadata metadata, List<List<ComplexReturnType>> result, ContextURL contextURL, URI nextLink) throws SerializerException {
        CircleStreamBuffer buffer = new CircleStreamBuffer();
        try {
            JsonGenerator json = new JsonFactory().createGenerator(buffer.getOutputStream());
            json.writeStartObject();
            if (contextURL != null) {
                json.writeStringField("@odata.context", ContextURLBuilder.create((ContextURL)contextURL).toASCIIString());
            }
            json.writeFieldName("value");
            json.writeStartArray();
            for (List<ComplexReturnType> ct : result) {
                json.writeStartObject();
                for (ComplexReturnType type : ct) {
                    if (!type.isExpand()) {
                        json.writeStringField(type.getName() + "@odata.navigationLink", type.getEntity().getId().toASCIIString());
                        continue;
                    }
                    json.writeFieldName(type.getName());
                    this.writeEntity(metadata, type.getEdmEntityType(), type.getEntity(), null, null, null, null, false, null, type.getName(), json);
                }
                json.writeEndObject();
            }
            json.writeEndArray();
            if (nextLink != null) {
                json.writeStringField("@odata.nextLink", nextLink.toASCIIString());
            }
            json.close();
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return SerializerResultImpl.with().content(buffer.getInputStream()).build();
    }
}

