/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.web.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class GzipMessageResponse
extends HttpServletResponseWrapper {
    private ServletOutputStream returnedStream;
    private PrintWriter returnedWriter;
    private final Charset charset;

    public GzipMessageResponse(HttpServletResponse response) {
        super(response);
        String cs = response.getCharacterEncoding();
        this.charset = cs == null || cs.isEmpty() ? Charset.defaultCharset() : Charset.forName(cs);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.returnedWriter != null) {
            throw new IllegalStateException("Method getWriter() has already been called.");
        }
        if (this.returnedStream == null) {
            this.returnedStream = new GzipServletOutputStream(super.getOutputStream());
        }
        return this.returnedStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.returnedStream != null) {
            throw new IllegalStateException("Method getOutputStream() has already been called.");
        }
        if (this.returnedWriter == null) {
            this.returnedWriter = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)new GzipServletOutputStream(super.getOutputStream())), this.charset));
        }
        return this.returnedWriter;
    }

    private class GzipServletOutputStream
    extends ServletOutputStream {
        private final OutputStream dest;
        private final ServletOutputStream origin;

        private GzipServletOutputStream(ServletOutputStream origin) throws IOException {
            this.dest = new GZIPOutputStream((OutputStream)origin);
            this.origin = origin;
        }

        public void write(int b) throws IOException {
            this.dest.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.dest.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.dest.write(b, off, len);
        }

        public void close() throws IOException {
            this.dest.close();
            super.close();
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
            if (this.origin != null) {
                this.origin.setWriteListener(writeListener);
            }
        }
    }
}

