/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.hadoop.io;

import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.tensorflow.hadoop.io.TFRecordIOConf;
import org.tensorflow.hadoop.util.TFRecordReader;

public class TFRecordFileInputFormat
extends FileInputFormat<BytesWritable, NullWritable> {
    public RecordReader<BytesWritable, NullWritable> createRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        return new RecordReader<BytesWritable, NullWritable>(){
            private FSDataInputStream fsdis;
            private TFRecordReader reader;
            private long length;
            private long begin;
            private byte[] current;

            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                Configuration conf = context.getConfiguration();
                FileSplit fileSplit = (FileSplit)split;
                this.length = fileSplit.getLength();
                this.begin = fileSplit.getStart();
                Path file = fileSplit.getPath();
                FileSystem fs = file.getFileSystem(conf);
                this.fsdis = fs.open(file, TFRecordIOConf.getBufferSize(conf));
                this.reader = new TFRecordReader((DataInput)this.fsdis, TFRecordIOConf.getDoCrc32Check(conf));
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                this.current = this.reader.read();
                return this.current != null;
            }

            public BytesWritable getCurrentKey() throws IOException, InterruptedException {
                return new BytesWritable(this.current);
            }

            public NullWritable getCurrentValue() throws IOException, InterruptedException {
                return NullWritable.get();
            }

            public float getProgress() throws IOException, InterruptedException {
                return (float)(this.fsdis.getPos() - this.begin) / ((float)this.length + 1.0E-6f);
            }

            public void close() throws IOException {
                this.fsdis.close();
            }
        };
    }

    protected boolean isSplitable(JobContext context, Path file) {
        return false;
    }
}

