/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.hadoop.util;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.tensorflow.hadoop.util.Crc32C;

public class TFRecordReader {
    private final DataInput input;
    private final boolean crcCheck;

    public TFRecordReader(DataInput input, boolean crcCheck) {
        this.input = input;
        this.crcCheck = crcCheck;
    }

    public byte[] read() throws IOException {
        byte[] lenBytes = new byte[8];
        try {
            this.input.readFully(lenBytes);
        }
        catch (EOFException eof) {
            return null;
        }
        Long len = this.fromInt64LE(lenBytes);
        if (!this.crcCheck) {
            this.input.skipBytes(4);
        } else {
            byte[] lenCrc32Bytes = new byte[4];
            this.input.readFully(lenCrc32Bytes);
            int lenCrc32 = this.fromInt32LE(lenCrc32Bytes);
            if (lenCrc32 != Crc32C.maskedCrc32c(lenBytes)) {
                throw new IOException("Length header crc32 checking failed: " + lenCrc32 + " != " + Crc32C.maskedCrc32c(lenBytes) + ", length = " + len);
            }
        }
        if (len > Integer.MAX_VALUE) {
            throw new IOException("Record size exceeds max value of int32: " + len);
        }
        byte[] data = new byte[len.intValue()];
        this.input.readFully(data);
        if (!this.crcCheck) {
            this.input.skipBytes(4);
        } else {
            byte[] dataCrc32Bytes = new byte[4];
            this.input.readFully(dataCrc32Bytes);
            int dataCrc32 = this.fromInt32LE(dataCrc32Bytes);
            if (dataCrc32 != Crc32C.maskedCrc32c(data)) {
                throw new IOException("Data crc32 checking failed: " + dataCrc32 + " != " + Crc32C.maskedCrc32c(data));
            }
        }
        return data;
    }

    private long fromInt64LE(byte[] data) {
        assert (data.length == 8);
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb.getLong();
    }

    private int fromInt32LE(byte[] data) {
        assert (data.length == 4);
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb.getInt();
    }
}

