/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.apt;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.tentackle.apt.visitor.SuperTypeVisitor;
import org.tentackle.reflect.Interceptable;

public abstract class AbstractInterceptorAnnotationProcessor
extends AbstractProcessor {
    private final Type type;
    private Types typeUtils;
    private SuperTypeVisitor typeVisitor;

    public AbstractInterceptorAnnotationProcessor(Type type) {
        this.type = type;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeVisitor = new SuperTypeVisitor(processingEnv, true);
        this.typeUtils = processingEnv.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            this.processAnnotation(typeElement, roundEnv);
        }
        return true;
    }

    private void processAnnotation(TypeElement annotationType, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
            if (element.getKind().equals((Object)ElementKind.METHOD)) {
                Element enclosingElement = element.getEnclosingElement();
                if (this.type == Type.PUBLIC && enclosingElement.getKind().equals((Object)ElementKind.INTERFACE) || this.type == Type.HIDDEN && enclosingElement.getKind().equals((Object)ElementKind.CLASS) || this.type == Type.ALL && (enclosingElement.getKind().equals((Object)ElementKind.INTERFACE) || enclosingElement.getKind().equals((Object)ElementKind.CLASS))) {
                    TypeElement classElement = (TypeElement)enclosingElement;
                    while (classElement != null) {
                        for (TypeMirror typeMirror : classElement.getInterfaces()) {
                            if (!((Boolean)typeMirror.accept(this.typeVisitor, Interceptable.class)).booleanValue()) continue;
                            if (this.type == Type.HIDDEN && enclosingElement.getKind().equals((Object)ElementKind.INTERFACE)) {
                                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + annotationType.getSimpleName() + " cannot be applied to a method of an Interceptable interface", element);
                            }
                            return;
                        }
                        TypeMirror superType = classElement.getSuperclass();
                        if (superType == null || superType.getKind() == TypeKind.NONE || superType.getKind() == TypeKind.VOID || superType.getKind() == TypeKind.PACKAGE) break;
                        classElement = (TypeElement)this.typeUtils.asElement(superType);
                    }
                }
                if (this.type == Type.PUBLIC) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + annotationType.getSimpleName() + " can only be applied to a method of an Interceptable interface", element);
                    continue;
                }
                if (this.type == Type.HIDDEN) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + annotationType.getSimpleName() + " can only be applied to a method of a class implementing Interceptable", element);
                    continue;
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + annotationType.getSimpleName() + " can only be applied to a method of an Interceptable interface or a class implementing Interceptable", element);
                continue;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "annotated element '" + element + "' is not a method", element);
        }
    }

    public static enum Type {
        PUBLIC,
        HIDDEN,
        ALL;

    }
}

