/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.apt;

import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.tentackle.apt.visitor.NoArgsVisitor;
import org.tentackle.apt.visitor.SuperTypeVisitor;

public abstract class AbstractServiceAnnotationProcessor
extends AbstractProcessor {
    protected Types typeUtils;
    protected Elements elementUtils;
    protected SuperTypeVisitor typeVisitor;
    protected NoArgsVisitor noArgsVisitor;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeVisitor = new SuperTypeVisitor(processingEnv, true);
        this.noArgsVisitor = new NoArgsVisitor();
    }

    public boolean acceptTypeVisitor(TypeMirror m, Class<?> v) {
        Boolean accept;
        TypeVariable typeVar;
        TypeMirror upper;
        if (m.getKind() == TypeKind.TYPEVAR && (upper = (typeVar = (TypeVariable)m).getUpperBound()) != null) {
            m = upper;
        }
        return (accept = (Boolean)m.accept(this.typeVisitor, v)) == null ? false : accept;
    }

    public void verifyImplements(Element element, String className) {
        TypeMirror assignableType = this.typeUtils.erasure(this.elementUtils.getTypeElement(className).asType());
        TypeMirror elementType = this.typeUtils.erasure(element.asType());
        if (!this.typeUtils.isAssignable(elementType, assignableType)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "class " + element + " must implement " + className, element);
        }
    }

    public boolean verifyConstructor(Element el, TypeVisitor<Boolean, Void> visitor) {
        for (Element element : el.getEnclosedElements()) {
            TypeMirror mirror;
            if (element.getKind() != ElementKind.CONSTRUCTOR || !element.getModifiers().contains((Object)Modifier.PUBLIC) || !(mirror = element.asType()).accept(visitor, null).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected void processClass(Element element) {
        if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "class " + element + " cannot be abstract", element);
        }
    }
}

