/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.apt;

import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.tentackle.common.AnnotationProcessor;
import org.tentackle.reflect.Interception;

@SupportedAnnotationTypes(value={"org.tentackle.reflect.Interception"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@AnnotationProcessor
public class InterceptionAnnotationProcessor
extends AbstractProcessor {
    private static final String ANNO_NAME = Interception.class.getName();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            this.processAnnotation(typeElement, roundEnv);
        }
        return true;
    }

    private void processAnnotation(TypeElement annotationType, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
            if (element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) {
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    if (!annotationMirror.getAnnotationType().toString().equals(ANNO_NAME)) continue;
                    int validCount = 0;
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                        String implName = entry.getKey().getSimpleName().toString();
                        String implValue = entry.getValue().toString();
                        if (!("implementedBy".equals(implName) && !ANNO_NAME.equals(implValue) || "implementedByName".equals(implName) && !implValue.isEmpty()) && (!"implementedByService".equals(implName) || implValue.isEmpty())) continue;
                        ++validCount;
                    }
                    if (validCount <= true) continue;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "only one of implementedBy, implementedByName or implementedByService must be specified", element);
                }
                continue;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "annotated element '" + element + "' is not an annotation", element);
        }
    }
}

