/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.apt.visitor;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;

public class SuperTypeVisitor
extends SimpleTypeVisitor8<Boolean, Class<?>> {
    private final ProcessingEnvironment processingEnv;
    private final boolean checkInterfaces;

    public SuperTypeVisitor(ProcessingEnvironment processingEnv, boolean checkInterfaces) {
        this.processingEnv = processingEnv;
        this.checkInterfaces = checkInterfaces;
    }

    @Override
    public Boolean visitDeclared(DeclaredType t, Class<?> v) {
        return this.visitDeclared(t, v.getName());
    }

    @Override
    private boolean visitDeclared(DeclaredType t, String className) {
        boolean rv = this.visit(t, className);
        if (!rv && this.checkInterfaces) {
            for (TypeMirror typeMirror : ((TypeElement)t.asElement()).getInterfaces()) {
                if (typeMirror.getKind() != TypeKind.DECLARED || !this.visit((DeclaredType)typeMirror, className)) continue;
                return true;
            }
        }
        return rv;
    }

    private boolean visit(DeclaredType t, String className) {
        String elementName = t.asElement().toString();
        if (!elementName.startsWith("java.")) {
            if (t.asElement().toString().equals(className)) {
                return true;
            }
            for (TypeMirror typeMirror : this.processingEnv.getTypeUtils().directSupertypes(t)) {
                if (!this.visitDeclared((DeclaredType)typeMirror, className)) continue;
                return true;
            }
        }
        return false;
    }
}

