/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.bind;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.tentackle.bind.Binder;
import org.tentackle.bind.Binding;
import org.tentackle.bind.BindingEvent;
import org.tentackle.bind.BindingMember;
import org.tentackle.bind.BindingVetoException;
import org.tentackle.bind.ToModelListener;
import org.tentackle.bind.ToViewListener;
import org.tentackle.validate.ValidationEvent;
import org.tentackle.validate.ValidationListener;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationScopeFactory;

public abstract class AbstractBinder
implements Binder {
    private static final AtomicLong INSTANCE_COUNT = new AtomicLong();
    private final long instanceNumber = INSTANCE_COUNT.incrementAndGet();
    private final Map<Object, Object> bindingProperties = new HashMap<Object, Object>();
    private List<ToViewListener> toViewListeners;
    private List<ToModelListener> toModelListeners;
    private List<ValidationListener> validationListeners;
    private ValidationScope validationScope = ValidationScopeFactory.getInstance().getInteractiveScope();

    @Override
    public Object putBindingProperty(Object key, Object value) {
        return this.bindingProperties.put(key, value);
    }

    @Override
    public Object getBindingProperty(Object key) {
        return this.bindingProperties.get(key);
    }

    @Override
    public <T> T getBindingProperty(Class<T> clazz) {
        return (T)this.bindingProperties.get(clazz);
    }

    @Override
    public synchronized void addToViewListener(ToViewListener l) {
        this.getToViewListeners().add(l);
    }

    @Override
    public synchronized void removeToViewListener(ToViewListener l) {
        this.getToViewListeners().remove(l);
    }

    @Override
    public List<ToViewListener> getToViewListeners() {
        if (this.toViewListeners == null) {
            this.toViewListeners = new ArrayList<ToViewListener>();
        }
        return this.toViewListeners;
    }

    @Override
    public synchronized void addToModelListener(ToModelListener l) {
        this.getToModelListeners().add(l);
    }

    @Override
    public synchronized void removeToModelListener(ToModelListener l) {
        this.getToModelListeners().remove(l);
    }

    @Override
    public List<ToModelListener> getToModelListeners() {
        if (this.toModelListeners == null) {
            this.toModelListeners = new ArrayList<ToModelListener>();
        }
        return this.toModelListeners;
    }

    @Override
    public synchronized void addValidationListener(ValidationListener l) {
        this.getValidationListeners().add(l);
    }

    @Override
    public synchronized void removeValidationListener(ValidationListener l) {
        this.getValidationListeners().remove(l);
    }

    @Override
    public List<ValidationListener> getValidationListeners() {
        if (this.validationListeners == null) {
            this.validationListeners = new ArrayList<ValidationListener>();
        }
        return this.validationListeners;
    }

    @Override
    public void setValidationScope(ValidationScope validationScope) {
        this.validationScope = validationScope;
    }

    @Override
    public ValidationScope getValidationScope() {
        return this.validationScope;
    }

    @Override
    public void fireToView(Binding binding, Object parent, Object modelValue) throws BindingVetoException {
        if (this.toViewListeners != null) {
            BindingEvent evt = null;
            for (ToViewListener l : this.toViewListeners) {
                if (evt == null) {
                    evt = binding.createBindingEvent(true, parent, modelValue);
                }
                l.toView(evt);
            }
        }
    }

    @Override
    public void fireToModel(Binding binding, Object parent, Object viewValue) throws BindingVetoException {
        if (this.toViewListeners != null) {
            BindingEvent evt = null;
            for (ToModelListener l : this.toModelListeners) {
                if (evt == null) {
                    evt = binding.createBindingEvent(false, parent, viewValue);
                }
                l.toModel(evt);
            }
        }
    }

    @Override
    public void fireValidated(Binding binding, List<ValidationResult> results) {
        if (this.validationListeners != null) {
            ValidationEvent evt = null;
            for (ValidationListener l : this.validationListeners) {
                if (evt == null) {
                    evt = binding.createValidationEvent(results);
                }
                l.validated(evt);
            }
        }
    }

    @Override
    public long getInstanceNumber() {
        return this.instanceNumber;
    }

    @Override
    public int compareTo(Binder other) {
        if (other != null) {
            return Long.compare(this.instanceNumber, other.getInstanceNumber());
        }
        return Integer.MAX_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBinder other = (AbstractBinder)obj;
        return this.instanceNumber == other.instanceNumber;
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + (int)(this.instanceNumber ^ this.instanceNumber >>> 32);
        return hash;
    }

    protected abstract int doBind(BindingMember[] var1, String var2, Class<?> var3, boolean var4);
}

