/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.bind;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tentackle.bind.Binder;
import org.tentackle.bind.Binding;
import org.tentackle.bind.BindingEvent;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingMember;
import org.tentackle.bind.BindingVetoException;
import org.tentackle.bind.ToModelListener;
import org.tentackle.bind.ToViewListener;
import org.tentackle.common.StringHelper;
import org.tentackle.log.Logger;
import org.tentackle.validate.DefaultScope;
import org.tentackle.validate.ValidationContext;
import org.tentackle.validate.ValidationEvent;
import org.tentackle.validate.ValidationListener;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationUtilities;
import org.tentackle.validate.Validator;
import org.tentackle.validate.ValidatorCache;
import org.tentackle.validate.scope.AllScope;
import org.tentackle.validate.scope.ChangeableScope;
import org.tentackle.validate.scope.MandatoryScope;

public abstract class AbstractBinding
implements Binding {
    private static final Logger LOGGER = Logger.get(AbstractBinding.class);
    private final Binder binder;
    private final BindingMember[] parents;
    private final BindingMember member;
    private List<ToViewListener> toViewListeners;
    private List<ToModelListener> toModelListeners;
    private List<ValidationListener> validationListeners;
    private List<Validator> validators;

    public AbstractBinding(Binder binder, BindingMember[] parents, BindingMember member) {
        this.binder = binder;
        this.parents = parents;
        this.member = member;
    }

    public String toString() {
        return this.member + " <-> " + this.viewComponentToString();
    }

    @Override
    public Binder getBinder() {
        return this.binder;
    }

    @Override
    public BindingMember[] getParents() {
        return this.parents;
    }

    @Override
    public BindingMember getMember() {
        return this.member;
    }

    @Override
    public void setViewValue(Object value) {
        this.updateView(this.getParentObject(), value, true);
    }

    @Override
    public void setModelValue(Object value) {
        this.setModelValue(this.getParentObject(), value, true);
    }

    @Override
    public BindingEvent createBindingEvent(boolean toView, Object parent, Object value) {
        return new BindingEvent(this, toView ? (this.member.getGetter() != null ? BindingEvent.Type.TO_VIEW_VIA_GETTER : BindingEvent.Type.TO_VIEW_VIA_FIELD) : (this.member.getSetter() != null ? BindingEvent.Type.TO_MODEL_VIA_SETTER : BindingEvent.Type.TO_MODEL_VIA_FIELD), parent, value);
    }

    @Override
    public synchronized void addToViewListener(ToViewListener l) {
        this.getToViewListeners().add(l);
    }

    @Override
    public synchronized void removeToViewListener(ToViewListener l) {
        this.getToViewListeners().remove(l);
    }

    @Override
    public List<ToViewListener> getToViewListeners() {
        if (this.toViewListeners == null) {
            this.toViewListeners = new ArrayList<ToViewListener>();
        }
        return this.toViewListeners;
    }

    @Override
    public synchronized void addToModelListener(ToModelListener l) {
        this.getToModelListeners().add(l);
    }

    @Override
    public synchronized void removeToModelListener(ToModelListener l) {
        this.getToModelListeners().remove(l);
    }

    @Override
    public List<ToModelListener> getToModelListeners() {
        if (this.toModelListeners == null) {
            this.toModelListeners = new ArrayList<ToModelListener>();
        }
        return this.toModelListeners;
    }

    @Override
    public synchronized void addValidationListener(ValidationListener l) {
        this.getValidationListeners().add(l);
    }

    @Override
    public synchronized void removeValidationListener(ValidationListener l) {
        this.getValidationListeners().remove(l);
    }

    @Override
    public List<ValidationListener> getValidationListeners() {
        if (this.validationListeners == null) {
            this.validationListeners = new ArrayList<ValidationListener>();
        }
        return this.validationListeners;
    }

    @Override
    public boolean addValidator(Validator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList<Validator>();
        }
        return !this.validators.contains(validator) && this.validators.add(validator);
    }

    @Override
    public boolean removeValidator(Validator validator) {
        return this.validators != null && this.validators.remove(validator);
    }

    @Override
    public List<Validator> getValidators() {
        return this.validators;
    }

    @Override
    public void fireToView(Object parent, Object modelValue) throws BindingVetoException {
        BindingEvent evt = null;
        if (this.toViewListeners != null) {
            for (ToViewListener l : this.toViewListeners) {
                if (evt == null) {
                    evt = this.createBindingEvent(true, parent, modelValue);
                }
                l.toView(evt);
            }
        }
    }

    @Override
    public void fireToModel(Object parent, Object viewValue) throws BindingVetoException {
        BindingEvent evt = null;
        if (this.toModelListeners != null) {
            for (ToModelListener l : this.toModelListeners) {
                if (evt == null) {
                    evt = this.createBindingEvent(false, parent, viewValue);
                }
                l.toModel(evt);
            }
        }
    }

    @Override
    public Object getParentObject() {
        Object object = this.getBoundRootObject();
        if (this.parents != null) {
            for (BindingMember parentMember : this.getParents()) {
                if (object == null) break;
                try {
                    object = parentMember.getObject(object);
                }
                catch (RuntimeException ex) {
                    throw new BindingException("can't walk down to " + parentMember, ex);
                }
            }
        }
        return object;
    }

    @Override
    public Object getModelValue() {
        return this.getModelValue(this.getParentObject());
    }

    @Override
    public ValidationEvent createValidationEvent(List<ValidationResult> results) {
        return new ValidationEvent(this, results);
    }

    @Override
    public ValidationContext createValidationContext(ValidationScope scope) {
        return new ValidationContext(this.getMember().getMemberPath(), this.getMember().getType(), this.getModelValue(), this.getParentObject(), scope);
    }

    @Override
    public void fireValidated(List<ValidationResult> results) {
        if (this.validationListeners != null) {
            ValidationEvent evt = null;
            for (ValidationListener l : this.validationListeners) {
                if (evt == null) {
                    evt = this.createValidationEvent(results);
                }
                l.validated(evt);
            }
        }
    }

    @Override
    public List<ValidationResult> validate() {
        Object parentObject = this.getParentObject();
        if (this.validators != null && parentObject != null && this.isValidationRequired()) {
            List<ValidationResult> results = ValidationUtilities.getInstance().validateObject(this.validators, this.binder.getValidationScope(), this.member.getMemberPath(), parentObject, this.getModelValue(), this.getMember().getType());
            this.fireValidated(results);
            this.binder.fireValidated(this, results);
            return results;
        }
        return Collections.emptyList();
    }

    protected void setModelValue(Object parent, Object value, boolean honourResyncByVetoException) {
        LOGGER.fine(() -> this.member + " <- " + this.viewComponentToString() + " = " + StringHelper.objectToLoggableString((Object)value));
        try {
            if (parent != null) {
                this.fireToModel(parent, value);
                this.binder.fireToModel(this, parent, value);
                this.member.setObject(parent, value);
            } else {
                LOGGER.fine("(some) object reference was null, {0} not changed", this.member);
            }
        }
        catch (BindingVetoException veto) {
            LOGGER.fine(() -> {
                String msg = "veto for value " + StringHelper.objectToLoggableString((Object)value) + " from " + this.viewComponentToString() + " to " + this.member;
                if (veto.getMessage() != null) {
                    msg = msg + ": " + veto.getMessage();
                }
                return msg;
            });
            if (honourResyncByVetoException && veto.isResyncRequested()) {
                LOGGER.fine("view resynced from model");
                this.updateView(parent, this.getModelValue(parent), false);
            }
            if (veto.isRethrowEnabled()) {
                throw new BindingException(veto.getLocalizedMessage(), veto);
            }
        }
        catch (BindingException ex) {
            throw new BindingException(this.member + ": " + ex.getLocalizedMessage(), ex);
        }
    }

    protected void updateView(Object parent, Object value, boolean honourResyncByVetoException) {
        block3: {
            try {
                this.fireToView(parent, value);
                this.binder.fireToView(this, parent, value);
                this.updateView(value);
            }
            catch (BindingVetoException veto) {
                LOGGER.fine(() -> {
                    String msg = "veto for value " + StringHelper.objectToLoggableString((Object)value) + " from " + this.member + " to " + this.viewComponentToString();
                    if (veto.getMessage() != null) {
                        msg = msg + ": " + veto.getMessage();
                    }
                    return msg;
                });
                if (honourResyncByVetoException && veto.isResyncRequested()) {
                    LOGGER.fine("model resynced from view");
                    this.setModelValue(parent, value, false);
                }
                if (!veto.isRethrowEnabled()) break block3;
                throw new BindingException(veto.getLocalizedMessage(), veto);
            }
        }
    }

    protected Object getModelValue(Object parentObject) {
        try {
            Object modelValue = parentObject == null ? null : this.member.getObject(parentObject);
            LOGGER.fine(() -> this.viewComponentToString() + " <- " + this.member + " = " + StringHelper.objectToLoggableString((Object)modelValue) + (String)(parentObject == null ? "\n(some) object reference was null, " + this.viewComponentToString() + " not changed" : ""));
            return modelValue;
        }
        catch (BindingException ex) {
            throw new BindingException(this.member + ": " + ex.getLocalizedMessage(), ex);
        }
    }

    protected abstract Class<?> getViewType();

    protected abstract Object getBoundRootObject();

    protected abstract boolean isValidationRequired();

    protected abstract String viewComponentToString();

    protected abstract void updateView(Object var1);

    protected void determineValidators() {
        List<Validator> fieldValidators = ValidatorCache.getInstance().getFieldValidators(this.member.getField(), this.member.getGetter());
        this.validators = new ArrayList<Validator>();
        BindingScopeImpl scope = new BindingScopeImpl();
        for (Validator fieldValidator : fieldValidators) {
            if (!scope.appliesTo(fieldValidator.getConfiguredScopes(null))) continue;
            this.validators.add(fieldValidator);
        }
        if (this.validators.isEmpty()) {
            this.validators = null;
        }
    }

    private class BindingScopeImpl
    implements ValidationScope {
        private BindingScopeImpl() {
        }

        @Override
        public boolean appliesTo(Class<?> ... scopes) {
            if (scopes.length == 1 && DefaultScope.class.isAssignableFrom(scopes[0])) {
                return true;
            }
            for (Class<ValidationScope> clazz : scopes) {
                if (!clazz.isAssignableFrom(AllScope.class) && !clazz.isAssignableFrom(MandatoryScope.class) && !clazz.isAssignableFrom(ChangeableScope.class) && !clazz.isAssignableFrom(AbstractBinding.this.binder.getValidationScope().getClass())) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getName() {
            return "binding";
        }

        public String toString() {
            return this.getName() + "-scope";
        }
    }
}

