/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.bind;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.bind.BindableCache;
import org.tentackle.bind.BindableElement;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingFactory;
import org.tentackle.bind.BindingMember;
import org.tentackle.bind.DefaultBindableCache;
import org.tentackle.bind.DefaultBindableElement;
import org.tentackle.bind.DefaultBindingMember;
import org.tentackle.log.Logger;

public class AbstractBindingFactory
implements BindingFactory {
    private static final Logger LOGGER = Logger.get(AbstractBindingFactory.class);
    private final Map<Class<?>, Class<? extends BindableElement>> elementClassMap = new ConcurrentHashMap();
    private final Map<Class<?>, Class<? extends BindableElement>> allElementClassMap = new ConcurrentHashMap();
    private final BindableCache bindableCache = new DefaultBindableCache(this);

    @Override
    public BindableCache getBindableCache() {
        return this.bindableCache;
    }

    @Override
    public Class<? extends BindableElement> putBindableElementClass(Class<?> modelClass, Class<? extends BindableElement> elementClass) {
        return this.elementClassMap.put(modelClass, elementClass);
    }

    @Override
    public Class<? extends BindableElement> getBindableElementClass(Class<?> modelClass) {
        Class<? extends BindableElement> elementClass = this.allElementClassMap.get(modelClass);
        if (elementClass == null) {
            for (Class<?> clazz = modelClass; clazz != null && (elementClass = this.elementClassMap.get(clazz)) == null; clazz = clazz.getSuperclass()) {
            }
            this.allElementClassMap.put(modelClass, elementClass == null ? BindableElement.class : elementClass);
        } else if (elementClass == BindableElement.class) {
            elementClass = null;
        }
        return elementClass;
    }

    @Override
    public BindingMember createBindingMember(Class<?> parentClass, BindingMember parentMember, String memberName, String memberPath, BindableElement element) {
        return new DefaultBindingMember(parentClass, parentMember, memberName, memberPath, element);
    }

    @Override
    public BindableElement createBindableElement(Class<?> modelClass, String camelName) {
        BindableElement element;
        Class<? extends BindableElement> elementClass = this.getBindableElementClass(modelClass);
        if (elementClass != null) {
            try {
                Constructor<? extends BindableElement> con = elementClass.getConstructor(String.class);
                element = con.newInstance(camelName);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new BindingException("could not instantiate bindable element " + elementClass.getName(), ex);
            }
        } else {
            element = new DefaultBindableElement(camelName);
        }
        LOGGER.fine("created binding {0}", element);
        return element;
    }
}

