/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.bind;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.bind.Bindable;
import org.tentackle.bind.BindableCache;
import org.tentackle.bind.BindableElement;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingFactory;
import org.tentackle.common.StringHelper;
import org.tentackle.log.Logger;
import org.tentackle.reflect.ReflectionHelper;

public class DefaultBindableCache
implements BindableCache {
    private static final Logger LOGGER = Logger.get(DefaultBindableCache.class);
    private final BindingFactory bindingFactory;
    private final Map<Key, SortedMap<String, BindableElement>> clazzMap = new ConcurrentHashMap<Key, SortedMap<String, BindableElement>>();

    public DefaultBindableCache(BindingFactory bindingFactory) {
        this.bindingFactory = bindingFactory;
    }

    @Override
    public SortedMap<String, BindableElement> getBindableMap(Class<?> clazz, boolean declaredOnly) {
        Key key = this.createKey(clazz, declaredOnly);
        SortedMap<String, BindableElement> bindableMap = this.clazzMap.get(key);
        if (bindableMap == null) {
            bindableMap = new TreeMap<String, BindableElement>();
            Method[] methods = declaredOnly ? (clazz.isInterface() ? clazz.getMethods() : clazz.getDeclaredMethods()) : ReflectionHelper.getAllMethods(clazz, null, true, null, true);
            for (Method method : methods) {
                if (method.isBridge() || !method.isAnnotationPresent(Bindable.class)) continue;
                BindableElement info = null;
                String bindingOptions = method.getAnnotation(Bindable.class).options();
                String camelName = ReflectionHelper.getPathGetterName(method);
                if (camelName != null) {
                    info = this.bindingFactory.createBindableElement(method.getReturnType(), camelName);
                    info.setGetter(method);
                } else {
                    camelName = ReflectionHelper.getPathSetterName(method);
                    if (camelName != null) {
                        info = this.bindingFactory.createBindableElement(method.getParameterTypes()[0], camelName);
                        info.setSetter(method);
                    }
                }
                if (info == null) continue;
                camelName = StringHelper.firstToUpper((String)camelName);
                LOGGER.finer("bindable method {0} found", method);
                BindableElement oldInfo = (BindableElement)bindableMap.get(camelName);
                if (oldInfo != null) {
                    oldInfo.addBindingOptions(bindingOptions);
                    if (info.getGetter() != null) {
                        if (oldInfo.getGetter() != null) continue;
                        oldInfo.setGetter(info.getGetter());
                        continue;
                    }
                    if (info.getSetter() == null) continue;
                    if (oldInfo.getSetter() != null) {
                        throw new BindingException("more than one setters annotated with @Bindable in " + clazz.getName() + " for " + camelName);
                    }
                    oldInfo.setSetter(info.getSetter());
                    continue;
                }
                info.setBindingOptions(bindingOptions);
                bindableMap.put(camelName, info);
            }
            for (AccessibleObject accessibleObject : declaredOnly ? clazz.getDeclaredFields() : ReflectionHelper.getAllFields(clazz, null, true, null, true)) {
                if (!accessibleObject.isAnnotationPresent(Bindable.class)) continue;
                LOGGER.finer("bindable field {0} found", accessibleObject);
                String bindingOptions = ((Field)accessibleObject).getAnnotation(Bindable.class).options();
                String camelName = StringHelper.firstToUpper((String)((Field)accessibleObject).getName());
                BindableElement info = (BindableElement)bindableMap.get(camelName);
                if (info != null) {
                    info.setField((Field)accessibleObject);
                    info.addBindingOptions(bindingOptions);
                    continue;
                }
                info = this.bindingFactory.createBindableElement(((Field)accessibleObject).getType(), camelName);
                info.setField((Field)accessibleObject);
                info.setBindingOptions(bindingOptions);
                bindableMap.put(camelName, info);
            }
            this.clazzMap.put(key, bindableMap);
        }
        return bindableMap;
    }

    private Key createKey(Class<?> clazz, boolean declaredOnly) {
        return new Key(clazz, declaredOnly);
    }

    private static class Key {
        private final Class<?> clazz;
        private final boolean declaredOnly;

        private Key(Class<?> clazz, boolean declaredOnly) {
            this.clazz = clazz;
            this.declaredOnly = declaredOnly;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!(this.clazz == other.clazz || this.clazz != null && this.clazz.equals(other.clazz))) {
                return false;
            }
            return this.declaredOnly == other.declaredOnly;
        }

        public int hashCode() {
            int hash = 3;
            hash = 29 * hash + (this.clazz != null ? this.clazz.hashCode() : 0);
            hash = 29 * hash + (this.declaredOnly ? 1 : 0);
            return hash;
        }
    }
}

