/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.bind;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.tentackle.bind.BindableElement;
import org.tentackle.bind.BindingException;

public class DefaultBindableElement
implements BindableElement {
    private String camelName;
    private Field field;
    private Method getter;
    private Method setter;
    private String bindingOptions;
    private Class<?> type;
    private Type genericType;

    public DefaultBindableElement(String camelName) {
        this.camelName = camelName;
    }

    @Override
    public String getCamelName() {
        return this.camelName;
    }

    @Override
    public void setCamelName(String camelName) {
        this.camelName = camelName;
    }

    @Override
    public String getBindingOptions() {
        return this.bindingOptions;
    }

    @Override
    public void setBindingOptions(String bindingOptions) {
        this.bindingOptions = bindingOptions;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public void setField(Field field) {
        this.field = field;
    }

    @Override
    public Method getGetter() {
        return this.getter;
    }

    @Override
    public void setGetter(Method getter) {
        this.getter = getter;
    }

    @Override
    public Method getSetter() {
        return this.setter;
    }

    @Override
    public void setSetter(Method setter) {
        this.setter = setter;
    }

    @Override
    public void addBindingOptions(String options) {
        if (options != null && options.length() > 0) {
            this.bindingOptions = this.bindingOptions == null || this.bindingOptions.isEmpty() ? options : this.bindingOptions + "," + options;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Object getObject(Object parent) {
        block8: {
            if (this.getter == null) break block8;
            try {
                return this.getter.invoke(parent, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                this.getter.setAccessible(true);
                return this.getter.invoke(parent, new Object[0]);
            }
            {
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new BindingException("cannot get " + this.camelName, ex);
                }
            }
        }
        try {
            return this.field.get(parent);
        }
        catch (IllegalAccessException ex) {
            this.field.setAccessible(true);
            return this.field.get(parent);
        }
    }

    @Override
    public void setObject(Object parent, Object value) {
        this.getType();
        try {
            if (value == null && this.type.isPrimitive()) {
                value = this.type.equals(Boolean.TYPE) ? Boolean.FALSE : (this.type == Character.TYPE ? (Comparable<Character>)Character.valueOf(' ') : (Comparable<Character>)Byte.valueOf((byte)0));
            }
            if (this.setter != null) {
                try {
                    this.setter.invoke(parent, value);
                }
                catch (IllegalAccessException ex) {
                    this.setter.setAccessible(true);
                    this.setter.invoke(parent, value);
                }
            } else if (this.field != null) {
                try {
                    this.field.set(parent, value);
                }
                catch (IllegalAccessException ex) {
                    this.field.setAccessible(true);
                    this.field.set(parent, value);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new BindingException("cannot set " + this.camelName, ex);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.field == null && this.setter == null;
    }

    @Override
    public boolean isWriteOnly() {
        return this.field == null && this.getter == null;
    }

    @Override
    public Class<?> getType() {
        if (this.type == null) {
            if (this.getter != null) {
                this.type = this.getter.getReturnType();
            } else if (this.field != null) {
                this.type = this.field.getType();
            } else {
                throw new BindingException("no getter or field for " + this.camelName);
            }
            if (this.type.equals(Void.TYPE)) {
                throw new BindingException("void type is not allowed");
            }
        }
        return this.type;
    }

    @Override
    public Type getGenericType() {
        if (this.genericType == null) {
            if (this.getter != null) {
                this.genericType = this.getter.getGenericReturnType();
            } else if (this.field != null) {
                this.genericType = this.field.getGenericType();
            } else {
                throw new BindingException("no getter or field for " + this.camelName);
            }
        }
        return this.genericType;
    }
}

