/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.daemon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.daemon.Scavenger;
import org.tentackle.daemon.Supervisable;
import org.tentackle.log.Logger;

public abstract class DaemonSupervisor
extends Thread
implements Scavenger {
    private static final Logger LOGGER = Logger.get(DaemonSupervisor.class);
    private long checkInterval;
    private int maxStartCount;
    private Daemon[] daemons;
    private final List<Thread> killedDaemons;
    private volatile boolean stopRequested;
    private final ReentrantReadWriteLock lock;

    public DaemonSupervisor(String name, long checkInterval, int maxStartCount, int daemonNum) {
        super(name);
        this.setCheckInterval(checkInterval);
        this.setMaxStartCount(maxStartCount);
        this.lock = new ReentrantReadWriteLock();
        this.killedDaemons = new ArrayList<Thread>();
        this.setDaemon(true);
        this.setDaemonNum(daemonNum);
    }

    public DaemonSupervisor(String name, long checkInterval, int maxStartCount) {
        this(name, checkInterval, maxStartCount, 1);
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        if (checkInterval < 1L) {
            throw new IllegalArgumentException("checkInterval must be > 0");
        }
        this.checkInterval = checkInterval;
        LOGGER.info("{0}: check interval = {1}", this, checkInterval);
    }

    public int getMaxStartCount() {
        return this.maxStartCount;
    }

    public void setMaxStartCount(int maxStartCount) {
        if (maxStartCount < 0) {
            throw new IllegalArgumentException("maxStartCount must be >= 0");
        }
        this.maxStartCount = maxStartCount;
        LOGGER.info("{0}: max. start count = {1}", this, maxStartCount);
    }

    public int getDaemonNum() {
        this.lock.readLock().lock();
        try {
            int n = this.daemons == null ? 0 : this.daemons.length;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDaemonNum(int daemonNum) {
        block14: {
            if (daemonNum < 0) {
                throw new IllegalArgumentException("daemonNum must be >= 0");
            }
            LOGGER.info("{0}: number of daemons = {1}", this, daemonNum);
            this.lock.writeLock().lock();
            try {
                if (this.daemons == null) {
                    this.daemons = new Daemon[daemonNum];
                    for (int i = 0; i < this.daemons.length; ++i) {
                        this.daemons[i] = new Daemon(i);
                    }
                    break block14;
                }
                if (daemonNum == this.daemons.length) break block14;
                Daemon[] oldDaemons = this.daemons;
                int daemonDiff = daemonNum - oldDaemons.length;
                Daemon[] newDaemons = new Daemon[daemonNum];
                if (daemonDiff < 0) {
                    for (int i = oldDaemons.length - 1; i >= 0 && daemonDiff < 0; --i) {
                        Daemon daemon = oldDaemons[i];
                        if (daemon.supervisable != null && !daemon.supervisable.isKilled()) {
                            daemon.kill();
                        }
                        if (!daemon.supervisableKilled) continue;
                        oldDaemons[i] = null;
                        ++daemonDiff;
                    }
                    if (daemonDiff < 0) {
                        throw new TentackleRuntimeException("cannot decrease daemonNum: no more supervisables to kill");
                    }
                    int j = 0;
                    for (Daemon oldDaemon : oldDaemons) {
                        if (oldDaemon == null) continue;
                        newDaemons[j++] = oldDaemon;
                    }
                } else if (daemonDiff > 0) {
                    for (int i = 0; i < daemonNum; ++i) {
                        newDaemons[i] = i < oldDaemons.length ? oldDaemons[i] : new Daemon(i);
                    }
                }
                this.daemons = newDaemons;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void clearStartCount(int index) {
        Daemon daemon = this.getDaemon(index);
        if (daemon != null) {
            daemon.clearStartCount();
        }
    }

    public boolean isDaemonEnabled(int index) {
        Daemon daemon = this.getDaemon(index);
        return daemon != null && daemon.isEnabled();
    }

    public void setDaemonEnabled(int index, boolean enabled) {
        Daemon daemon = this.getDaemon(index);
        if (daemon != null) {
            daemon.setEnabled(enabled);
        }
    }

    public void requestTermination() {
        this.stopRequested = true;
        this.safeInterrupt();
    }

    public void terminate() {
        this.requestTermination();
        while (true) {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                LOGGER.warning("termination interrupted -> ignored");
                continue;
            }
            break;
        }
    }

    public abstract Thread createDaemon(int var1);

    public Thread getRunningDaemon(int index) {
        Thread t = this.getStartedDaemon(index);
        return t == null || !t.isAlive() ? null : t;
    }

    public Thread getStartedDaemon(int index) {
        Daemon daemon = this.getDaemon(index);
        return daemon == null || daemon.supervisedDaemon == null ? null : daemon.supervisedDaemon;
    }

    public TerminationInfo getTerminationInfo(int index) {
        TerminationInfo info = null;
        Daemon daemon = this.getDaemon(index);
        if (daemon != null && (info = daemon.terminationInfo) == null) {
            info = daemon.lastTerminationInfo;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread[] getStartedDaemons() {
        this.lock.readLock().lock();
        try {
            int startCount = 0;
            for (Daemon daemon : this.daemons) {
                if (daemon.supervisedDaemon == null) continue;
                ++startCount;
            }
            Thread[] startedThreads = new Thread[startCount];
            startCount = 0;
            for (Daemon daemon : this.daemons) {
                if (daemon.supervisedDaemon == null) continue;
                startedThreads[startCount++] = daemon.supervisedDaemon;
            }
            Object[] objectArray = startedThreads;
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Thread[] getRunningDaemons() {
        ArrayList<Thread> runningThreads = new ArrayList<Thread>();
        for (Thread thread : this.getStartedDaemons()) {
            if (!thread.isAlive()) continue;
            runningThreads.add(thread);
        }
        return runningThreads.toArray(new Thread[0]);
    }

    public long getEarliestStartTime() {
        long time = 0L;
        for (Thread thread : this.getStartedDaemons()) {
            long startedAt;
            if (!(thread instanceof Supervisable) || (startedAt = ((Supervisable)((Object)thread)).startedAt()) == 0L || time != 0L && startedAt >= time) continue;
            time = startedAt;
        }
        return time;
    }

    public long getLatestStartTime() {
        long time = 0L;
        for (Thread thread : this.getStartedDaemons()) {
            long startedAt;
            if (!(thread instanceof Supervisable) || (startedAt = ((Supervisable)((Object)thread)).startedAt()) <= time) continue;
            time = startedAt;
        }
        return time;
    }

    public long getEarliestTerminationTime() {
        long time = 0L;
        for (Thread thread : this.getStartedDaemons()) {
            long terminatedAt;
            if (!(thread instanceof Supervisable) || (terminatedAt = ((Supervisable)((Object)thread)).terminatedAt()) == 0L || time != 0L && terminatedAt >= time) continue;
            time = terminatedAt;
        }
        return time;
    }

    public long getLatestTerminationTime() {
        long time = 0L;
        for (Thread thread : this.getStartedDaemons()) {
            long terminatedAt;
            if (!(thread instanceof Supervisable) || (terminatedAt = ((Supervisable)((Object)thread)).terminatedAt()) <= time) continue;
            time = terminatedAt;
        }
        return time;
    }

    public void cleanupDaemon(Thread daemon) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        LOGGER.info("daemon supervisor {0} started", this.getClass().getName());
        while (!this.stopRequested) {
            this.lock.readLock().lock();
            try {
                void var1_3;
                boolean bl = false;
                while (var1_3 < this.daemons.length) {
                    Daemon daemon = this.daemons[var1_3];
                    if (daemon.supervisable != null && daemon.supervisable.isDead() && !daemon.supervisable.isKilled()) {
                        LOGGER.warning((daemon.supervisedDaemon != null && !daemon.supervisedDaemon.isAlive() ? "daemon has terminated: " : "dead daemon detected: ") + daemon.supervisable);
                        try {
                            daemon.kill();
                        }
                        catch (RuntimeException rex) {
                            LOGGER.severe("killing " + daemon.supervisedDaemon + " failed", rex);
                        }
                    }
                    if (daemon.supervisedDaemon != null && daemon.supervisedDaemon.isAlive()) {
                        if (!this.isDaemonEnabled((int)var1_3)) {
                            daemon.kill();
                        } else {
                            daemon.lastTerminationInfo = daemon.terminationInfo;
                            daemon.terminationInfo = null;
                        }
                    } else {
                        if (daemon.supervisedDaemon != null) {
                            LOGGER.info("cleanup: {0}", daemon.supervisedDaemon);
                            try {
                                this.cleanupDaemon(daemon.supervisedDaemon);
                                daemon.clear();
                            }
                            catch (RuntimeException rex) {
                                LOGGER.severe("cleanup " + daemon.supervisedDaemon + " failed", rex);
                            }
                        }
                        if (daemon.isEnabled() && !daemon.isStartCountExceeded()) {
                            try {
                                daemon.setThread(this.createDaemon((int)var1_3));
                            }
                            catch (RuntimeException rex) {
                                LOGGER.severe("creating daemon failed", rex);
                            }
                            if (daemon.supervisedDaemon != null) {
                                daemon.start();
                            }
                        }
                    }
                    ++var1_3;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            try {
                DaemonSupervisor.sleep(this.checkInterval);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warning("interrupted -> ignored");
            }
            List<Thread> object = this.killedDaemons;
            synchronized (object) {
                Iterator<Thread> iter = this.killedDaemons.iterator();
                while (iter.hasNext()) {
                    Thread killedDaemon = iter.next();
                    try {
                        if (killedDaemon.isAlive()) {
                            killedDaemon.interrupt();
                            continue;
                        }
                        iter.remove();
                        LOGGER.info("{0} has terminated", killedDaemon);
                    }
                    catch (RuntimeException rex) {
                        LOGGER.severe("cleanup pending thread failed", rex);
                    }
                }
            }
        }
        for (Daemon daemon : this.daemons) {
            if (daemon.supervisable == null || daemon.supervisable.isKilled()) continue;
            daemon.kill();
        }
        LOGGER.info("daemon supervisor {0} terminated", this.getClass().getName());
    }

    public void safeInterrupt() {
        this.lock.writeLock().lock();
        try {
            this.interrupt();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Daemon getDaemon(int index) {
        this.lock.readLock().lock();
        try {
            int daemonNum = this.getDaemonNum();
            if (index < 0 || index >= daemonNum) {
                Daemon daemon = null;
                return daemon;
            }
            Daemon daemon = this.daemons[index];
            return daemon;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private class Daemon {
        private Thread supervisedDaemon;
        private final int daemonIndex;
        private Supervisable supervisable;
        private boolean supervisableKilled;
        private int startCount;
        private boolean enabled = true;
        private TerminationInfo terminationInfo;
        private TerminationInfo lastTerminationInfo;

        private Daemon(int daemonIndex) {
            this.daemonIndex = daemonIndex;
        }

        private void setThread(Thread supervisedDaemon) {
            this.supervisedDaemon = supervisedDaemon;
            this.supervisable = supervisedDaemon instanceof Supervisable ? (Supervisable)((Object)supervisedDaemon) : null;
            this.supervisableKilled = false;
        }

        private boolean isStartCountExceeded() {
            return DaemonSupervisor.this.maxStartCount > 0 && this.startCount >= DaemonSupervisor.this.maxStartCount;
        }

        private void start() {
            ++this.startCount;
            LOGGER.info(() -> {
                StringBuilder msg = new StringBuilder("starting ");
                msg.append(this);
                msg.append(" (attempt ");
                msg.append(this.startCount);
                if (DaemonSupervisor.this.maxStartCount > 0) {
                    msg.append(" of ");
                    msg.append(DaemonSupervisor.this.maxStartCount);
                }
                msg.append(")");
                return msg.toString();
            });
            this.supervisedDaemon.start();
        }

        private void clear() {
            if (this.supervisable != null) {
                this.lastTerminationInfo = null;
                this.terminationInfo = new TerminationInfo(this.supervisable.getName(), this.supervisable.getTerminationCause());
            }
            this.supervisedDaemon = null;
            this.supervisable = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void kill() {
            this.supervisable.kill();
            this.supervisableKilled = true;
            List<Thread> list = DaemonSupervisor.this.killedDaemons;
            synchronized (list) {
                DaemonSupervisor.this.killedDaemons.add(this.supervisedDaemon);
            }
            this.clear();
        }

        private void clearStartCount() {
            this.startCount = 0;
        }

        private void setEnabled(boolean enabled) {
            if (this.enabled != enabled) {
                this.enabled = enabled;
                if (enabled) {
                    this.startCount = 0;
                }
            }
        }

        private boolean isEnabled() {
            return this.enabled;
        }

        public String toString() {
            return (this.supervisable != null ? "supervisable" : "") + " daemon#" + this.daemonIndex + ": " + this.supervisedDaemon;
        }
    }

    public static class TerminationInfo {
        private final long since = System.currentTimeMillis();
        private final String name;
        private final Object cause;

        private TerminationInfo(String name, Object cause) {
            this.name = name;
            this.cause = cause;
        }

        public long getSince() {
            return this.since;
        }

        public String getName() {
            return this.name;
        }

        public Object getCause() {
            return this.cause;
        }
    }
}

