/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.io.IOException;
import java.io.Writer;

public class AppendableWriter
extends Writer {
    private static final String NULL_STRING = "null";
    private final Appendable appendable;

    public AppendableWriter(Appendable appendable) {
        this.appendable = appendable;
    }

    public AppendableWriter() {
        this(new StringBuffer());
    }

    public Appendable getAppendable() {
        return this.appendable;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.appendable.append(new String(cbuf), off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.appendable.append(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.appendable.append(str.substring(off, off + len));
    }

    @Override
    public AppendableWriter append(CharSequence csq) throws IOException {
        if (csq == null) {
            this.write(NULL_STRING);
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public AppendableWriter append(CharSequence csq, int start, int end) throws IOException {
        CharSequence cs = csq == null ? NULL_STRING : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public AppendableWriter append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.appendable.toString();
    }
}

