/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.io.IOException;
import java.io.InputStream;
import org.tentackle.io.NotifyingByteArrayOutputStream;

public class BlockingByteArrayInputStream
extends InputStream {
    private final NotifyingByteArrayOutputStream out;
    private byte[] buf;
    private int pos;

    public BlockingByteArrayInputStream(NotifyingByteArrayOutputStream out) {
        this.out = out;
    }

    public NotifyingByteArrayOutputStream getOutputStream() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        while (true) {
            NotifyingByteArrayOutputStream notifyingByteArrayOutputStream = this.out;
            synchronized (notifyingByteArrayOutputStream) {
                if (this.buf == null || this.pos >= this.buf.length) {
                    if (this.out.size() == 0) {
                        try {
                            this.out.wait();
                        }
                        catch (InterruptedException ex) {
                            continue;
                        }
                    }
                } else {
                    return this.buf[this.pos++] & 0xFF;
                }
                this.buf = this.out.toByteArray();
                this.pos = 0;
                this.out.reset();
            }
        }
    }
}

