/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Objects;
import org.tentackle.io.SocketConfigurator;
import org.tentackle.io.SocketConfiguratorHolder;

public class ClientSocketFactory
implements RMIClientSocketFactory,
SocketConfiguratorHolder,
Serializable {
    private static final long serialVersionUID = 2357672465175511279L;
    protected volatile SocketConfigurator socketConfigurator;

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket(host, port);
        if (this.socketConfigurator != null) {
            this.socketConfigurator.configure(socket);
        }
        return socket;
    }

    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + this.getClass().hashCode();
        hash = 11 * hash + Objects.hashCode(this.socketConfigurator);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientSocketFactory other = (ClientSocketFactory)obj;
        return SocketConfigurator.equals(this.socketConfigurator, other.socketConfigurator);
    }

    @Override
    public SocketConfigurator getSocketConfigurator() {
        return this.socketConfigurator;
    }

    @Override
    public void setSocketConfigurator(SocketConfigurator socketConfigurator) {
        this.socketConfigurator = socketConfigurator;
    }
}

