/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.tentackle.log.Logger;

public class CompressedInputStream
extends FilterInputStream {
    private static final Logger LOGGER = Logger.get(CompressedInputStream.class);
    private final Inflater inflater = new Inflater(true);
    private final byte[] byteBuf = new byte[1];
    private byte[] infBuf;
    private boolean compressed;
    private int readPending;
    private boolean closed;
    private long totalRead;
    private long totalCompressed;
    private long totalUncompressed;

    public CompressedInputStream(InputStream in) {
        super(in);
        LOGGER.finer("compressed input stream ceated for: {0}", in);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            super.close();
            LOGGER.fine(() -> "compressed output stream stats: total=" + this.totalRead + ", compressed=" + this.totalCompressed + ", uncompressed=" + this.totalUncompressed + ", ratio=" + (int)((double)(this.totalCompressed + this.totalUncompressed) * 100.0 / (double)(this.totalRead == 0L ? 1L : this.totalRead)) + "%");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int read() throws IOException {
        int num = this.read(this.byteBuf, 0, 1);
        return num < 0 ? num : this.byteBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len <= 0 || off < 0 || off + len > b.length) {
            if (len == 0) {
                return 0;
            }
            throw new ArrayIndexOutOfBoundsException("b.length=" + b.length + ", off=" + off + ", len=" + len);
        }
        int count = 0;
        while (count == 0) {
            if (this.compressed) {
                try {
                    count = this.inflater.inflate(b, off, len);
                }
                catch (DataFormatException e) {
                    throw new IOException("decompression failed", e);
                }
                if (count > 0) continue;
                if (this.readPending == 0) {
                    if (!this.readHeader()) {
                        return -1;
                    }
                    if (!this.compressed) continue;
                }
                if (this.inflater.needsInput()) {
                    int num = this.in.read(this.infBuf, 0, this.readPending);
                    LOGGER.finer("read into infBuf: {0}", num);
                    if (num < 0) {
                        throw new EOFException();
                    }
                    this.readPending -= num;
                    this.totalCompressed += (long)num;
                    this.inflater.setInput(this.infBuf, 0, num);
                    continue;
                }
                throw new IOException("nothing decompressed but inflator does not request more input");
            }
            if (this.readPending == 0) {
                if (!this.readHeader()) {
                    return -1;
                }
                if (this.compressed) continue;
            }
            if ((count = this.readPending) > len) {
                count = len;
            }
            count = this.in.read(b, off, count);
            LOGGER.finer("read uncompressed: {0}", count);
            if (count < 0) {
                throw new EOFException();
            }
            this.readPending -= count;
            this.totalUncompressed += (long)count;
        }
        this.totalRead += (long)count;
        return count;
    }

    private boolean readHeader() throws IOException {
        int ch1 = this.in.read();
        if (ch1 < 0) {
            return false;
        }
        int ch2 = this.in.read();
        if (ch2 < 0) {
            throw new EOFException();
        }
        this.readPending = (ch1 << 8) + ch2;
        this.compressed = (this.readPending & 0x8000) == 32768;
        this.readPending &= 0xFFFF7FFF;
        if (this.compressed) {
            this.inflater.reset();
            if (this.infBuf == null || this.infBuf.length < this.readPending) {
                this.infBuf = new byte[this.readPending];
                LOGGER.finer("infBuf enlarged to: {0}", this.readPending);
            }
        }
        return true;
    }
}

