/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import org.tentackle.log.Logger;

public class CompressedOutputStream
extends FilterOutputStream {
    private static final Logger LOGGER = Logger.get(CompressedOutputStream.class);
    public static final int MAX_BUFFER_SIZE = Short.MAX_VALUE;
    static final int COMPRESSED = 32768;
    private int minCompressSize;
    private int bufSize;
    private final byte[] byteBuf = new byte[1];
    private byte[] orgBuf;
    private int orgLen;
    private Deflater deflater;
    private byte[] defBuf;
    private boolean closed;
    private long totalWritten;
    private long totalCompressed;
    private long totalUncompressed;

    public CompressedOutputStream(OutputStream out, int bufSize, int minCompressSize) {
        super(out);
        if (bufSize <= minCompressSize || bufSize > Short.MAX_VALUE) {
            throw new IllegalArgumentException("illegal bufSize [" + minCompressSize + " < ?" + bufSize + "? <= 32767]");
        }
        this.bufSize = bufSize;
        this.minCompressSize = minCompressSize;
        this.orgBuf = new byte[bufSize];
        this.deflater = new Deflater(-1, true);
        this.defBuf = new byte[bufSize];
    }

    public CompressedOutputStream(OutputStream out) {
        this(out, Short.MAX_VALUE, 64);
    }

    @Override
    public void write(int b) throws IOException {
        this.byteBuf[0] = (byte)b;
        this.write(this.byteBuf, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.totalWritten += (long)len;
        while (len > 0) {
            int num = len;
            if (num > this.bufSize - this.orgLen) {
                num = this.bufSize - this.orgLen;
            }
            System.arraycopy(b, off, this.orgBuf, this.orgLen, num);
            off += num;
            len -= num;
            this.orgLen += num;
            if (this.orgLen < this.bufSize) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        super.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.deflater.end();
            super.close();
            LOGGER.fine(() -> "compressed output stream stats: total=" + this.totalWritten + ", compressed=" + this.totalCompressed + ", uncompressed=" + this.totalUncompressed + ", ratio=" + (int)((double)(this.totalCompressed + this.totalUncompressed) * 100.0 / (double)(this.totalWritten == 0L ? 1L : this.totalWritten)) + "%");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void writeHeader(int size, boolean compressed) throws IOException {
        if (compressed) {
            size |= 0x8000;
        }
        this.out.write(size >>> 8 & 0xFF);
        this.out.write(size & 0xFF);
    }

    private void flushBuffer() throws IOException {
        if (this.orgLen > 0) {
            if (this.orgLen >= this.minCompressSize) {
                this.deflater.reset();
                this.deflater.setInput(this.orgBuf, 0, this.orgLen);
                this.deflater.finish();
                int defLen = 0;
                while (!this.deflater.finished()) {
                    int num = this.deflater.deflate(this.defBuf, defLen, this.bufSize - defLen);
                    if (num <= 0 && this.deflater.needsInput()) {
                        throw new IOException("Deflater needs more input! Bytes in buffer: " + this.orgLen);
                    }
                    defLen += num;
                }
                if (defLen < this.orgLen) {
                    this.writeHeader(defLen, true);
                    this.out.write(this.defBuf, 0, defLen);
                    this.totalCompressed += (long)defLen;
                    this.orgLen = 0;
                    LOGGER.fine("compressed packet written: {0}/{1}", defLen, this.orgLen);
                    return;
                }
            }
            this.writeHeader(this.orgLen, false);
            this.out.write(this.orgBuf, 0, this.orgLen);
            this.totalUncompressed += (long)this.orgLen;
            this.orgLen = 0;
            LOGGER.fine("uncompressed packet written: {0}", this.orgLen);
        }
    }
}

