/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.tentackle.io.CompressedInputStream;
import org.tentackle.io.CompressedOutputStream;

public class CompressedSocket
extends Socket {
    private CompressedOutputStream out;
    private CompressedInputStream in;

    public CompressedSocket(String host, int port) throws IOException {
        super(host, port);
    }

    public CompressedSocket() {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new CompressedInputStream(super.getInputStream());
        }
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new CompressedOutputStream(super.getOutputStream());
        }
        return this.out;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        super.close();
    }
}

