/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Objects;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.tentackle.io.CompressedSocketWrapper;
import org.tentackle.io.ServerSocketConfigurator;
import org.tentackle.io.ServerSocketConfiguratorHolder;
import org.tentackle.io.SocketConfigurator;
import org.tentackle.io.SocketConfiguratorHolder;

public class CompressedSslServerSocketFactory
extends SslRMIServerSocketFactory
implements ServerSocketConfiguratorHolder {
    private volatile ServerSocketConfigurator socketConfigurator;

    public CompressedSslServerSocketFactory(String[] enabledCipherSuites, String[] enabledProtocols, boolean needClientAuth) {
        super(enabledCipherSuites, enabledProtocols, needClientAuth);
    }

    public CompressedSslServerSocketFactory() {
        this(null, null, false);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this.createConfiguredServerSocket(port);
    }

    protected SSLSocketFactory getSslSocketFactory() {
        return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    @Override
    public ServerSocket createUnconfiguredServerSocket(int port) throws IOException {
        final SSLSocketFactory sslSocketFactory = this.getSslSocketFactory();
        return new ServerSocket(port){

            @Override
            public Socket accept() throws IOException {
                SocketConfigurator clientSocketConfigurator;
                Socket socket = super.accept();
                SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
                sslSocket.setUseClientMode(false);
                if (CompressedSslServerSocketFactory.this.getEnabledCipherSuites() != null) {
                    sslSocket.setEnabledCipherSuites(CompressedSslServerSocketFactory.this.getEnabledCipherSuites());
                }
                if (CompressedSslServerSocketFactory.this.getEnabledProtocols() != null) {
                    sslSocket.setEnabledProtocols(CompressedSslServerSocketFactory.this.getEnabledProtocols());
                }
                sslSocket.setNeedClientAuth(CompressedSslServerSocketFactory.this.getNeedClientAuth());
                if (sslSocketFactory instanceof SocketConfiguratorHolder && (clientSocketConfigurator = ((SocketConfiguratorHolder)((Object)sslSocketFactory)).getSocketConfigurator()) != null) {
                    clientSocketConfigurator.configure(sslSocket);
                }
                return new CompressedSocketWrapper(sslSocket);
            }
        };
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + super.hashCode();
        hash = 11 * hash + Objects.hashCode(this.socketConfigurator);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CompressedSslServerSocketFactory other = (CompressedSslServerSocketFactory)obj;
        return ServerSocketConfigurator.equals(this.socketConfigurator, other.socketConfigurator);
    }

    @Override
    public ServerSocketConfigurator getSocketConfigurator() {
        return this.socketConfigurator;
    }

    @Override
    public void setSocketConfigurator(ServerSocketConfigurator socketConfigurator) {
        this.socketConfigurator = socketConfigurator;
    }
}

