/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Objects;
import org.tentackle.io.ServerSocketConfigurator;
import org.tentackle.io.SocketConfiguratorBase;

public class DefaultServerSocketConfigurator
extends SocketConfiguratorBase
implements ServerSocketConfigurator {
    private static final long serialVersionUID = 1L;

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPortRange() {
        return this.portRange;
    }

    public void setPortRange(int portRange) {
        this.portRange = portRange;
    }

    public Integer getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(Integer receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    @Override
    public void configure(ServerSocket socket) throws SocketException {
        if (this.performancePreferences != null) {
            socket.setPerformancePreferences(this.performancePreferences.getConnectionTime(), this.performancePreferences.getLatency(), this.performancePreferences.getBandwidth());
        }
        if (this.receiveBufferSize != null) {
            socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.reuseAddress != null) {
            socket.setReuseAddress(this.reuseAddress);
        }
        if (this.soTimeout != null) {
            socket.setSoTimeout(this.soTimeout);
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() || this.port > 0 || this.portRange > 1 || this.receiveBufferSize != null;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (hash != 0) {
            hash = 11 * hash + Objects.hashCode(this.port);
            hash = 11 * hash + Objects.hashCode(this.portRange);
            hash = 11 * hash + Objects.hashCode(this.receiveBufferSize);
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null) {
            return true;
        }
        DefaultServerSocketConfigurator other = (DefaultServerSocketConfigurator)obj;
        if (this.port != other.port) {
            return false;
        }
        if (this.portRange != other.portRange) {
            return false;
        }
        return Objects.equals(this.receiveBufferSize, other.receiveBufferSize);
    }

    @Override
    public String toString() {
        String str;
        StringBuilder buf = new StringBuilder(super.toString());
        if (this.receiveBufferSize != null) {
            buf.append(", ").append("SNDBUF").append('=').append(this.sendBufferSize);
        }
        if (this.port > 0) {
            buf.append(", ").append("PORT").append('=').append(this.port);
        }
        if (this.portRange > 1) {
            buf.append(", ").append("RANGE").append('=').append(this.portRange);
        }
        if ((str = buf.toString()).startsWith(", ")) {
            return str.substring(2);
        }
        return str;
    }
}

