/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.net.Socket;
import java.net.SocketException;
import java.util.Objects;
import org.tentackle.io.SocketConfigurator;
import org.tentackle.io.SocketConfiguratorBase;

public class DefaultSocketConfigurator
extends SocketConfiguratorBase
implements SocketConfigurator {
    private static final long serialVersionUID = 1L;

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Boolean getOOBInline() {
        return this.oobInline;
    }

    public void setOOBInline(Boolean oobInline) {
        this.oobInline = oobInline;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public Integer getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(Integer sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public Integer getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(Integer soLinger) {
        this.soLinger = soLinger;
    }

    public Integer getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(Integer trafficClass) {
        this.trafficClass = trafficClass;
    }

    @Override
    public void configure(Socket socket) throws SocketException {
        if (this.keepAlive != null) {
            socket.setKeepAlive(this.keepAlive);
        }
        if (this.oobInline != null) {
            socket.setOOBInline(this.oobInline);
        }
        if (this.performancePreferences != null) {
            socket.setPerformancePreferences(this.performancePreferences.getConnectionTime(), this.performancePreferences.getLatency(), this.performancePreferences.getBandwidth());
        }
        if (this.reuseAddress != null) {
            socket.setReuseAddress(this.reuseAddress);
        }
        if (this.sendBufferSize != null) {
            socket.setSendBufferSize(this.sendBufferSize);
        }
        if (this.soLinger != null) {
            if (this.soLinger < 0) {
                socket.setSoLinger(false, 0);
            } else {
                socket.setSoLinger(true, this.soLinger);
            }
        }
        if (this.soTimeout != null) {
            socket.setSoTimeout(this.soTimeout);
        }
        if (this.tcpNoDelay != null) {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        if (this.trafficClass != null) {
            socket.setTrafficClass(this.trafficClass);
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() || this.keepAlive != null || this.oobInline != null || this.tcpNoDelay != null || this.sendBufferSize != null || this.soLinger != null || this.trafficClass != null;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (hash != 0) {
            hash = 11 * hash + Objects.hashCode(this.keepAlive);
            hash = 11 * hash + Objects.hashCode(this.oobInline);
            hash = 11 * hash + Objects.hashCode(this.tcpNoDelay);
            hash = 11 * hash + Objects.hashCode(this.sendBufferSize);
            hash = 11 * hash + Objects.hashCode(this.soLinger);
            hash = 11 * hash + Objects.hashCode(this.trafficClass);
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null) {
            return true;
        }
        DefaultSocketConfigurator other = (DefaultSocketConfigurator)obj;
        if (!Objects.equals(this.keepAlive, other.keepAlive)) {
            return false;
        }
        if (!Objects.equals(this.oobInline, other.oobInline)) {
            return false;
        }
        if (!Objects.equals(this.tcpNoDelay, other.tcpNoDelay)) {
            return false;
        }
        if (!Objects.equals(this.sendBufferSize, other.sendBufferSize)) {
            return false;
        }
        if (!Objects.equals(this.soLinger, other.soLinger)) {
            return false;
        }
        return Objects.equals(this.trafficClass, other.trafficClass);
    }

    @Override
    public String toString() {
        String str;
        StringBuilder buf = new StringBuilder(super.toString());
        if (this.keepAlive != null) {
            buf.append(", ").append("KEEPALIVE").append('=').append(this.keepAlive);
        }
        if (this.oobInline != null) {
            buf.append(", ").append("OOBINLINE").append('=').append(this.oobInline);
        }
        if (this.tcpNoDelay != null) {
            buf.append(", ").append("NODELAY").append('=').append(this.tcpNoDelay);
        }
        if (this.sendBufferSize != null) {
            buf.append(", ").append("SNDBUF").append('=').append(this.sendBufferSize);
        }
        if (this.soLinger != null) {
            buf.append(", ").append("LINGER").append('=').append(this.soLinger);
        }
        if (this.trafficClass != null) {
            buf.append(", ").append("TOS").append('=').append(this.trafficClass);
        }
        if ((str = buf.toString()).startsWith(", ")) {
            return str.substring(2);
        }
        return str;
    }
}

