/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import org.tentackle.common.Service;
import org.tentackle.io.ClientSocketFactory;
import org.tentackle.io.CompressedClientSocketFactory;
import org.tentackle.io.CompressedServerSocketFactory;
import org.tentackle.io.CompressedSslClientSocketFactory;
import org.tentackle.io.CompressedSslServerSocketFactory;
import org.tentackle.io.RMISocketFactoryFactoryHolder;
import org.tentackle.io.RMISocketFactoryType;
import org.tentackle.io.ServerSocketFactory;
import org.tentackle.io.SslClientSocketFactory;
import org.tentackle.io.SslServerSocketFactory;

@Service(value=RMISocketFactoryFactory.class)
public class RMISocketFactoryFactory {
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;
    private boolean clientAuthenticationRequired;

    public static RMISocketFactoryFactory getInstance() {
        return RMISocketFactoryFactoryHolder.INSTANCE;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isClientAuthenticationRequired() {
        return this.clientAuthenticationRequired;
    }

    public void setClientAuthenticationRequired(boolean clientAuthenticationRequired) {
        this.clientAuthenticationRequired = clientAuthenticationRequired;
    }

    public RMIClientSocketFactory createClientSocketFactory(RMIClientSocketFactory defaultFactory, RMISocketFactoryType factoryType) {
        RMIClientSocketFactory factory;
        switch (factoryType) {
            case DEFAULT: {
                factory = defaultFactory;
                break;
            }
            case PLAIN: {
                factory = new ClientSocketFactory();
                break;
            }
            case SSL: {
                factory = new SslClientSocketFactory();
                break;
            }
            case COMPRESSED: {
                factory = new CompressedClientSocketFactory();
                break;
            }
            case SSL_COMPRESSED: {
                factory = new CompressedSslClientSocketFactory();
                break;
            }
            default: {
                factory = null;
            }
        }
        return factory;
    }

    public RMIServerSocketFactory createServerSocketFactory(RMIServerSocketFactory defaultFactory, RMISocketFactoryType factoryType) {
        RMIServerSocketFactory factory;
        switch (factoryType) {
            case DEFAULT: {
                factory = defaultFactory;
                break;
            }
            case PLAIN: {
                factory = new ServerSocketFactory();
                break;
            }
            case SSL: {
                factory = new SslServerSocketFactory(this.getEnabledCipherSuites(), this.getEnabledProtocols(), this.isClientAuthenticationRequired());
                break;
            }
            case COMPRESSED: {
                factory = new CompressedServerSocketFactory();
                break;
            }
            case SSL_COMPRESSED: {
                factory = new CompressedSslServerSocketFactory(this.getEnabledCipherSuites(), this.getEnabledProtocols(), this.isClientAuthenticationRequired());
                break;
            }
            default: {
                factory = null;
            }
        }
        return factory;
    }
}

