/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.util.StringTokenizer;

public enum RMISocketFactoryType {
    SYSTEM,
    DEFAULT,
    PLAIN,
    SSL,
    COMPRESSED,
    SSL_COMPRESSED;


    public static RMISocketFactoryType parse(String config) {
        RMISocketFactoryType type = SYSTEM;
        if (config != null) {
            StringTokenizer stok = new StringTokenizer(config, ", \t");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                switch (token.toLowerCase()) {
                    case "default": {
                        type = DEFAULT;
                        break;
                    }
                    case "system": {
                        type = SYSTEM;
                        break;
                    }
                    case "plain": {
                        type = PLAIN;
                        break;
                    }
                    case "ssl": {
                        type = type == COMPRESSED ? SSL_COMPRESSED : SSL;
                        break;
                    }
                    case "compressed": {
                        type = type == SSL ? SSL_COMPRESSED : COMPRESSED;
                    }
                }
            }
        }
        return type;
    }
}

