/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import org.tentackle.common.TentackleRuntimeException;
import org.tentackle.io.SocketPerformancePreferences;
import org.tentackle.misc.ParameterString;

public abstract class SocketConfiguratorBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SO_REUSEADDR = "REUSEADDR";
    public static final String SO_TIMEOUT = "TIMEOUT";
    public static final String PERF_PREFS = "PERFPREFS";
    public static final String SO_KEEPALIVE = "KEEPALIVE";
    public static final String SO_OOBINLINE = "OOBINLINE";
    public static final String TCP_NODELAY = "NODELAY";
    public static final String SO_SNDBUF = "SNDBUF";
    public static final String SO_LINGER = "LINGER";
    public static final String IP_TOS = "TOS";
    public static final String SO_RCVBUF = "RCVBUF";
    public static final String PORT = "PORT";
    public static final String RANGE = "RANGE";
    protected Boolean reuseAddress;
    protected Integer soTimeout;
    protected SocketPerformancePreferences performancePreferences;
    protected Boolean keepAlive;
    protected Boolean oobInline;
    protected Boolean tcpNoDelay;
    protected Integer sendBufferSize;
    protected Integer soLinger;
    protected Integer trafficClass;
    protected Integer receiveBufferSize;
    protected int port;
    protected int portRange;

    public Boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(Boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(Integer timeout) {
        this.soTimeout = timeout;
    }

    public SocketPerformancePreferences getPerformancePreferences() {
        return this.performancePreferences;
    }

    public void setPerformancePreferences(SocketPerformancePreferences performancePreferences) {
        this.performancePreferences = performancePreferences;
    }

    public void applyProperties(Properties properties) {
        if (properties != null) {
            block28: for (String key : properties.stringPropertyNames()) {
                switch (key.toUpperCase()) {
                    case "REUSEADDR": {
                        this.reuseAddress = Boolean.valueOf(properties.getProperty(key));
                        continue block28;
                    }
                    case "TIMEOUT": {
                        this.soTimeout = Integer.decode(properties.getProperty(key));
                        continue block28;
                    }
                    case "PERFPREFS": {
                        String prefs = properties.getProperty(key);
                        StringTokenizer stok = new StringTokenizer(prefs, ", ");
                        if (stok.countTokens() != 3) {
                            throw new TentackleRuntimeException("expected 'n,n,n', got '" + prefs + "'");
                        }
                        this.performancePreferences = new SocketPerformancePreferences(Integer.decode(stok.nextToken()), Integer.decode(stok.nextToken()), Integer.decode(stok.nextToken()));
                        continue block28;
                    }
                    case "KEEPALIVE": {
                        this.keepAlive = Boolean.valueOf(properties.getProperty(key));
                        continue block28;
                    }
                    case "OOBINLINE": {
                        this.oobInline = Boolean.valueOf(properties.getProperty(key));
                        continue block28;
                    }
                    case "NODELAY": {
                        this.tcpNoDelay = Boolean.valueOf(properties.getProperty(key));
                        continue block28;
                    }
                    case "SNDBUF": {
                        this.sendBufferSize = Integer.decode(properties.getProperty(key));
                        continue block28;
                    }
                    case "LINGER": {
                        this.soLinger = Integer.decode(properties.getProperty(key));
                        continue block28;
                    }
                    case "TOS": {
                        this.trafficClass = Integer.decode(properties.getProperty(key));
                        continue block28;
                    }
                    case "RCVBUF": {
                        this.receiveBufferSize = Integer.decode(properties.getProperty(key));
                        continue block28;
                    }
                    case "RANGE": {
                        this.portRange = Integer.decode(properties.getProperty(key));
                        continue block28;
                    }
                    case "PORT": {
                        this.port = Integer.decode(properties.getProperty(key));
                        continue block28;
                    }
                }
                throw new TentackleRuntimeException("illegal socket option: " + key);
            }
        }
    }

    public void applyParameters(String parameters) {
        try {
            this.applyProperties(new ParameterString(parameters).toProperties());
        }
        catch (ParseException pex) {
            throw new TentackleRuntimeException("applying parameters failed", (Throwable)pex);
        }
    }

    public boolean isValid() {
        return this.reuseAddress != null || this.soTimeout != null || this.performancePreferences != null;
    }

    public int hashCode() {
        if (this.isValid()) {
            int hash = 5;
            hash = 11 * hash + Objects.hashCode(this.reuseAddress);
            hash = 11 * hash + Objects.hashCode(this.soTimeout);
            hash = 11 * hash + Objects.hashCode(this.performancePreferences);
            return hash;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return !this.isValid();
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SocketConfiguratorBase other = (SocketConfiguratorBase)obj;
        if (!Objects.equals(this.reuseAddress, other.reuseAddress)) {
            return false;
        }
        if (!Objects.equals(this.soTimeout, other.soTimeout)) {
            return false;
        }
        return Objects.equals(this.performancePreferences, other.performancePreferences);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.reuseAddress != null) {
            buf.append(", ").append(SO_REUSEADDR).append('=').append(this.reuseAddress);
        }
        if (this.soTimeout != null) {
            buf.append(", ").append(SO_TIMEOUT).append('=').append(this.soTimeout);
        }
        if (this.performancePreferences != null) {
            buf.append(", ").append(PERF_PREFS).append('=').append(this.performancePreferences);
        }
        return buf.toString();
    }
}

