/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;

public class SocketImplWrapper
extends SocketImpl {
    private final Socket soc;

    public SocketImplWrapper(Socket socket) {
        this.soc = socket;
    }

    @Override
    protected void shutdownInput() throws IOException {
        this.soc.shutdownInput();
    }

    @Override
    protected void shutdownOutput() throws IOException {
        this.soc.shutdownOutput();
    }

    @Override
    protected FileDescriptor getFileDescriptor() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected InetAddress getInetAddress() {
        return this.soc.getInetAddress();
    }

    @Override
    protected int getPort() {
        return this.soc.getPort();
    }

    @Override
    protected int getLocalPort() {
        return this.soc.getLocalPort();
    }

    @Override
    protected void create(boolean stream) throws IOException {
        throw new WrappedException();
    }

    @Override
    protected void connect(String host, int port) throws IOException {
        throw new WrappedException();
    }

    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        throw new WrappedException();
    }

    @Override
    protected void connect(SocketAddress address, int timeout) throws IOException {
        throw new WrappedException();
    }

    @Override
    protected void bind(InetAddress host, int port) throws IOException {
        throw new WrappedException();
    }

    @Override
    protected void listen(int backlog) throws IOException {
        throw new WrappedException();
    }

    @Override
    protected void accept(SocketImpl s) throws IOException {
        throw new WrappedException();
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return this.soc.getInputStream();
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return this.soc.getOutputStream();
    }

    @Override
    protected int available() throws IOException {
        return this.getInputStream().available();
    }

    @Override
    protected void close() throws IOException {
        this.soc.close();
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        throw new WrappedException();
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        Integer ival;
        Boolean bval;
        if (value instanceof Boolean) {
            bval = (Boolean)value;
            ival = 0;
        } else {
            ival = (Integer)value;
            bval = ival > 0;
        }
        switch (optID) {
            case 1: {
                this.soc.setTcpNoDelay(bval);
                break;
            }
            case 4: {
                this.soc.setReuseAddress(bval);
                break;
            }
            case 3: {
                this.soc.setTrafficClass(ival);
                break;
            }
            case 128: {
                this.soc.setSoLinger(bval, ival);
                break;
            }
            case 4102: {
                this.soc.setSoTimeout(ival);
                break;
            }
            case 4097: {
                this.soc.setSendBufferSize(ival);
                break;
            }
            case 4098: {
                this.soc.setReceiveBufferSize(ival);
                break;
            }
            case 8: {
                this.soc.setKeepAlive(bval);
                break;
            }
            case 4099: {
                this.soc.setOOBInline(bval);
                break;
            }
            default: {
                throw new SocketException("unsupported option ID");
            }
        }
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        switch (optID) {
            case 1: {
                return this.soc.getTcpNoDelay();
            }
            case 15: {
                return this.soc.getLocalAddress();
            }
            case 4: {
                return this.soc.getReuseAddress();
            }
            case 3: {
                return this.soc.getTrafficClass();
            }
            case 128: {
                return this.soc.getSoLinger();
            }
            case 4102: {
                return this.soc.getSoTimeout();
            }
            case 4097: {
                return this.soc.getSendBufferSize();
            }
            case 4098: {
                return this.soc.getReceiveBufferSize();
            }
            case 8: {
                return this.soc.getKeepAlive();
            }
            case 4099: {
                return this.soc.getOOBInline();
            }
        }
        throw new SocketException("unsupported option ID");
    }

    private static class WrappedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        private WrappedException() {
            super("operation not allowed for wrapped socket");
        }
    }
}

