/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.io;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.tentackle.io.SocketImplWrapper;

public abstract class SocketWrapper
extends Socket {
    private final Socket socket;

    public SocketWrapper(Socket socket) throws SocketException {
        super(new SocketImplWrapper(socket));
        this.socket = socket;
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.socket.bind(bindpoint);
    }

    @Override
    public boolean isBound() {
        return this.socket.isBound();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.socket.connect(endpoint, timeout);
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public boolean equals(Object obj) {
        return obj instanceof SocketWrapper && ((SocketWrapper)obj).socket.equals(this.socket);
    }

    public int hashCode() {
        return this.socket.hashCode();
    }
}

