/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.log;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.tentackle.common.StringHelper;
import org.tentackle.log.DefaultMappedDiagnosticContext;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerOutputStream;

public class DefaultLogger
implements Logger {
    private static final HashMap<String, DefaultLogger> LOGGERS = new HashMap();
    private final java.util.logging.Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultLogger getLogger(String name) {
        HashMap<String, DefaultLogger> hashMap = LOGGERS;
        synchronized (hashMap) {
            return LOGGERS.computeIfAbsent(name, DefaultLogger::new);
        }
    }

    public DefaultLogger(String name) {
        this.logger = java.util.logging.Logger.getLogger(name);
    }

    @Override
    public Object getLoggerImpl() {
        return this.logger;
    }

    private Level translateLevel(Logger.Level level) {
        switch (level) {
            case FINER: {
                return Level.FINER;
            }
            case FINE: {
                return Level.FINE;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARNING: {
                return Level.WARNING;
            }
        }
        return Level.SEVERE;
    }

    @Override
    public boolean isLoggable(Logger.Level level) {
        return this.logger.isLoggable(this.translateLevel(level));
    }

    @Override
    public void log(Logger.Level level, String message, Throwable cause) {
        this.doLog(level, message, cause, new Object[0]);
    }

    @Override
    public void log(Logger.Level level, Throwable cause, Supplier<String> messageSupplier) {
        this.doLog(level, cause, messageSupplier);
    }

    @Override
    public void finer(String message) {
        this.doLog(Logger.Level.FINER, message, null, new Object[0]);
    }

    @Override
    public void fine(String message) {
        this.doLog(Logger.Level.FINE, message, null, new Object[0]);
    }

    @Override
    public void info(String message) {
        this.doLog(Logger.Level.INFO, message, null, new Object[0]);
    }

    @Override
    public void warning(String message) {
        this.doLog(Logger.Level.WARNING, message, null, new Object[0]);
    }

    @Override
    public void severe(String message) {
        this.doLog(Logger.Level.SEVERE, message, null, new Object[0]);
    }

    @Override
    public void finer(String message, Object ... params) {
        this.doLog(Logger.Level.FINER, message, null, params);
    }

    @Override
    public void fine(String message, Object ... params) {
        this.doLog(Logger.Level.FINE, message, null, params);
    }

    @Override
    public void info(String message, Object ... params) {
        this.doLog(Logger.Level.INFO, message, null, params);
    }

    @Override
    public void warning(String message, Object ... params) {
        this.doLog(Logger.Level.WARNING, message, null, params);
    }

    @Override
    public void severe(String message, Object ... params) {
        this.doLog(Logger.Level.SEVERE, message, null, params);
    }

    @Override
    public void finer(String message, Supplier<?> ... paramSuppliers) {
        this.doLog(Logger.Level.FINER, null, message, paramSuppliers);
    }

    @Override
    public void fine(String message, Supplier<?> ... paramSuppliers) {
        this.doLog(Logger.Level.FINE, null, message, paramSuppliers);
    }

    @Override
    public void info(String message, Supplier<?> ... paramSuppliers) {
        this.doLog(Logger.Level.INFO, null, message, paramSuppliers);
    }

    @Override
    public void warning(String message, Supplier<?> ... paramSuppliers) {
        this.doLog(Logger.Level.WARNING, null, message, paramSuppliers);
    }

    @Override
    public void severe(String message, Supplier<?> ... paramSuppliers) {
        this.doLog(Logger.Level.SEVERE, null, message, paramSuppliers);
    }

    @Override
    public void finer(String message, Throwable cause) {
        this.doLog(Logger.Level.FINER, message, cause, new Object[0]);
    }

    @Override
    public void fine(String message, Throwable cause) {
        this.doLog(Logger.Level.FINE, message, cause, new Object[0]);
    }

    @Override
    public void info(String message, Throwable cause) {
        this.doLog(Logger.Level.INFO, message, cause, new Object[0]);
    }

    @Override
    public void warning(String message, Throwable cause) {
        this.doLog(Logger.Level.WARNING, message, cause, new Object[0]);
    }

    @Override
    public void severe(String message, Throwable cause) {
        this.doLog(Logger.Level.SEVERE, message, cause, new Object[0]);
    }

    @Override
    public void finer(Throwable cause, Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.FINER, cause, messageSupplier);
    }

    @Override
    public void fine(Throwable cause, Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.FINE, cause, messageSupplier);
    }

    @Override
    public void info(Throwable cause, Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.INFO, cause, messageSupplier);
    }

    @Override
    public void warning(Throwable cause, Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.WARNING, cause, messageSupplier);
    }

    @Override
    public void severe(Throwable cause, Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.SEVERE, cause, messageSupplier);
    }

    @Override
    public void finer(Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.FINER, null, messageSupplier);
    }

    @Override
    public void fine(Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.FINE, null, messageSupplier);
    }

    @Override
    public void info(Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.INFO, null, messageSupplier);
    }

    @Override
    public void warning(Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.WARNING, null, messageSupplier);
    }

    @Override
    public void severe(Supplier<String> messageSupplier) {
        this.doLog(Logger.Level.SEVERE, null, messageSupplier);
    }

    @Override
    public boolean isFinerLoggable() {
        return this.isLoggable(Logger.Level.FINER);
    }

    @Override
    public boolean isFineLoggable() {
        return this.isLoggable(Logger.Level.FINE);
    }

    @Override
    public boolean isInfoLoggable() {
        return this.isLoggable(Logger.Level.INFO);
    }

    @Override
    public boolean isWarningLoggable() {
        return this.isLoggable(Logger.Level.WARNING);
    }

    @Override
    public boolean isSevereLoggable() {
        return this.isLoggable(Logger.Level.SEVERE);
    }

    @Override
    public void logStacktrace(Logger.Level level, Throwable cause) {
        try (PrintStream ps = new PrintStream(new LoggerOutputStream(this, level));){
            cause.printStackTrace(ps);
        }
    }

    @Override
    public void logStacktrace(Throwable cause) {
        this.logStacktrace(Logger.Level.SEVERE, cause);
    }

    @Override
    public DefaultMappedDiagnosticContext getMappedDiagnosticContext() {
        return DefaultMappedDiagnosticContext.getInstance();
    }

    protected void doLog(Logger.Level level, String message, Throwable cause, Object ... params) {
        this.doLog(level, cause, () -> this.buildMessage(message, params));
    }

    protected void doLog(Logger.Level level, Throwable cause, String message, Supplier<?> ... paramSuppliers) {
        this.doLog(level, cause, () -> {
            Object[] params = new Object[paramSuppliers.length];
            for (int i = 0; i < params.length; ++i) {
                Supplier supplier = paramSuppliers[i];
                params[i] = supplier == null ? null : supplier.get();
            }
            return this.buildMessage(message, params);
        });
    }

    protected void doLog(Logger.Level level, Throwable cause, Supplier<String> messageSupplier) {
        Level juLevel = this.translateLevel(level);
        if (this.logger.isLoggable(juLevel)) {
            String loggerName = this.getClass().getName();
            Optional sfOpt = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(s -> s.dropWhile(f -> f.getClassName().equals(loggerName)).findFirst());
            if (sfOpt.isPresent()) {
                StackWalker.StackFrame sf = (StackWalker.StackFrame)sfOpt.get();
                LogRecord lr = new LogRecord(juLevel, messageSupplier.get());
                lr.setSourceClassName(sf.getClassName());
                lr.setSourceMethodName(sf.getMethodName());
                lr.setThrown(cause);
                lr.setLoggerName(this.logger.getName());
                this.logger.log(lr);
            }
        }
    }

    protected String buildMessage(String message, Object ... params) {
        Map<String, String> mdcMap = this.getMappedDiagnosticContext().getContext();
        if (!mdcMap.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append('[');
            boolean needComma = false;
            for (Map.Entry<String, String> entry : mdcMap.entrySet()) {
                if (needComma) {
                    buf.append(", ");
                } else {
                    needComma = true;
                }
                buf.append(StringHelper.objectToLoggableString((Object)entry.getKey()));
                buf.append('=');
                buf.append(StringHelper.objectToLoggableString((Object)entry.getValue()));
            }
            buf.append("] ");
            buf.append(message);
            message = buf.toString();
        }
        return params != null && params.length > 0 ? MessageFormat.format(message, params) : message;
    }
}

