/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.log;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.log.DefaultLogger;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;

@Service(value=LoggerFactory.class)
public class DefaultLoggerFactory
implements LoggerFactory {
    private static final Class<? extends Logger> LOGGER_CLASS = DefaultLoggerFactory.getConfiguredLoggerClass();
    private final ConcurrentHashMap<Class<? extends Logger>, Method> methods = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends Logger>, Constructor<Logger>> constructors = new ConcurrentHashMap();

    private static Class<? extends Logger> getConfiguredLoggerClass() {
        DefaultLogger logger = new DefaultLogger(DefaultLoggerFactory.class.getName());
        try {
            Class loggerClass = ServiceFactory.createServiceClass(Logger.class);
            logger.info("configured logger is " + loggerClass.getName());
            return loggerClass;
        }
        catch (RuntimeException ex) {
            String msg = "no logging backend configured -> using DefaultLogger";
            if (logger.isFineLoggable()) {
                logger.fine(msg, ex);
            } else {
                logger.info(msg);
            }
            return DefaultLogger.class;
        }
    }

    @Override
    public Logger getLogger(String name, Class<? extends Logger> loggerClass) {
        if (loggerClass == null) {
            loggerClass = LOGGER_CLASS;
        }
        Constructor<Logger> constructor = null;
        Method method = this.methods.get(loggerClass);
        if (method == null) {
            constructor = this.constructors.get(loggerClass);
        }
        Exception methodException = null;
        Exception constructorException = null;
        if (method == null && constructor == null) {
            try {
                method = loggerClass.getDeclaredMethod("getLogger", String.class);
                if (Modifier.isStatic(method.getModifiers())) {
                    this.methods.put(loggerClass, method);
                }
            }
            catch (NoSuchMethodException e) {
                methodException = e;
            }
            if (method == null) {
                try {
                    constructor = loggerClass.getConstructor(String.class);
                    this.constructors.put(loggerClass, constructor);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    constructorException = e;
                }
            }
        }
        if (method != null) {
            try {
                return (Logger)method.invoke(null, name);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                methodException = e;
            }
        } else if (constructor != null) {
            try {
                return constructor.newInstance(name);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                constructorException = e;
            }
        }
        String msg = "Could not load logger " + loggerClass;
        if (methodException != null) {
            msg = msg + " (via static method: " + methodException + ")";
        }
        if (constructorException != null) {
            msg = msg + " (via constructor: " + constructorException;
        }
        java.util.logging.Logger.getLogger(name).warning(msg);
        return DefaultLogger.getLogger(name);
    }
}

