/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.log;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.tentackle.log.Log;
import org.tentackle.log.Logger;
import org.tentackle.misc.Duration;
import org.tentackle.reflect.AbstractInterceptor;

public class LogInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = Logger.get(LogInterceptor.class);
    private Logger.Level level;

    @Override
    public void setAnnotation(Annotation annotation) {
        super.setAnnotation(annotation);
        this.level = ((Log)annotation).value();
    }

    @Override
    public Object proceed(Object proxy, Method method, Object[] args, Object orgProxy, Method orgMethod, Object[] orgArgs) throws Throwable {
        Duration duration = null;
        if (LOGGER.isLoggable(this.level)) {
            duration = new Duration();
        }
        Object value = method.invoke(proxy, args);
        if (duration != null) {
            duration.end();
            LOGGER.log(this.level, orgMethod.toGenericString() + " took " + duration.millisToString() + "ms", null);
        }
        return value;
    }
}

