/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.log;

import java.util.function.Supplier;
import org.tentackle.log.LoggerFactory;
import org.tentackle.log.MappedDiagnosticContext;

public interface Logger {
    public static Logger get(Class<?> clazz) {
        return LoggerFactory.getInstance().getLogger(clazz.getName(), null);
    }

    public static Logger get() {
        return Logger.get(StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass());
    }

    public boolean isLoggable(Level var1);

    public boolean isFinerLoggable();

    public boolean isFineLoggable();

    public boolean isInfoLoggable();

    public boolean isWarningLoggable();

    public boolean isSevereLoggable();

    public void log(Level var1, String var2, Throwable var3);

    public void log(Level var1, Throwable var2, Supplier<String> var3);

    public void finer(String var1);

    public void fine(String var1);

    public void info(String var1);

    public void warning(String var1);

    public void severe(String var1);

    public void finer(String var1, Object ... var2);

    public void fine(String var1, Object ... var2);

    public void info(String var1, Object ... var2);

    public void warning(String var1, Object ... var2);

    public void severe(String var1, Object ... var2);

    public void finer(String var1, Supplier<?> ... var2);

    public void fine(String var1, Supplier<?> ... var2);

    public void info(String var1, Supplier<?> ... var2);

    public void warning(String var1, Supplier<?> ... var2);

    public void severe(String var1, Supplier<?> ... var2);

    public void finer(String var1, Throwable var2);

    public void fine(String var1, Throwable var2);

    public void info(String var1, Throwable var2);

    public void warning(String var1, Throwable var2);

    public void severe(String var1, Throwable var2);

    public void finer(Throwable var1, Supplier<String> var2);

    public void fine(Throwable var1, Supplier<String> var2);

    public void info(Throwable var1, Supplier<String> var2);

    public void warning(Throwable var1, Supplier<String> var2);

    public void severe(Throwable var1, Supplier<String> var2);

    public void finer(Supplier<String> var1);

    public void fine(Supplier<String> var1);

    public void info(Supplier<String> var1);

    public void warning(Supplier<String> var1);

    public void severe(Supplier<String> var1);

    public void logStacktrace(Level var1, Throwable var2);

    public void logStacktrace(Throwable var1);

    public Object getLoggerImpl();

    public MappedDiagnosticContext getMappedDiagnosticContext();

    public static enum Level {
        FINER,
        FINE,
        INFO,
        WARNING,
        SEVERE;

    }
}

