/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.tentackle.log.Logger;

public class LoggerOutputStream
extends ByteArrayOutputStream {
    private static final Logger LOGGER = Logger.get(LoggerOutputStream.class);
    private final Logger logger;
    private final Logger.Level level;

    public LoggerOutputStream(Logger logger, Logger.Level level, int size) {
        super(size);
        this.logger = logger;
        this.level = level;
    }

    public LoggerOutputStream(Logger logger, Logger.Level level) {
        this(logger, level, 512);
    }

    public LoggerOutputStream(Logger logger) {
        this(logger, Logger.Level.SEVERE);
    }

    @Override
    public void flush() {
        this.logger.log(this.level, this.toString(), null);
        this.reset();
    }

    @Override
    public void close() {
        this.flush();
    }

    public static void logException(Exception e, Logger logger, Logger.Level level, int size) {
        PrintStream ps = new PrintStream(new LoggerOutputStream(logger, level, size));
        ps.println(e);
        e.printStackTrace(ps);
        ps.close();
    }

    public static void logException(Exception e, Logger logger) {
        LoggerOutputStream.logException(e, logger, Logger.Level.SEVERE, 512);
    }

    public static void logException(Exception e) {
        LoggerOutputStream.logException(e, LOGGER, Logger.Level.SEVERE, 512);
    }
}

