/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.log;

import org.tentackle.log.Logger;

public class LoggingRunnable
implements Runnable {
    private final Logger logger;
    private final Logger.Level level;
    private final Runnable runnable;

    public LoggingRunnable(Logger logger, Logger.Level level, Runnable runnable) {
        this.logger = logger;
        this.level = level;
        this.runnable = runnable;
    }

    @Override
    public void run() {
        if (this.logger.isLoggable(this.level)) {
            long startMillis = System.currentTimeMillis();
            this.logger.log(this.level, "start runnable " + this.runnable, null);
            this.runnable.run();
            long duration = System.currentTimeMillis() - startMillis;
            this.logger.log(this.level, "done runnable " + this.runnable + " (" + duration + "ms)", null);
        } else {
            this.runnable.run();
        }
    }
}

